/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.engine.impl;

import java.util.Set;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.engine.OutgoingAMQPEnvelope;
import org.apache.qpid.protonj2.engine.impl.ProtonEngine;
import org.apache.qpid.protonj2.engine.impl.ProtonOutgoingDelivery;
import org.apache.qpid.protonj2.engine.impl.ProtonSender;
import org.apache.qpid.protonj2.engine.impl.ProtonSession;
import org.apache.qpid.protonj2.engine.util.UnsettledMap;
import org.apache.qpid.protonj2.types.DeliveryTag;
import org.apache.qpid.protonj2.types.transport.Begin;
import org.apache.qpid.protonj2.types.transport.Disposition;
import org.apache.qpid.protonj2.types.transport.Flow;
import org.apache.qpid.protonj2.types.transport.Performative;
import org.apache.qpid.protonj2.types.transport.Role;
import org.apache.qpid.protonj2.types.transport.Transfer;

public class ProtonSessionOutgoingWindow {
    private final ProtonSession session;
    private final ProtonEngine engine;
    private final int localChannel;
    private int outgoingDeliveryId = 0;
    private int nextOutgoingId = 0;
    private int outgoingCapacity = -1;
    private int outgoingWindowHighWaterMark = Integer.MAX_VALUE;
    private int outgoingWindowLowWaterMark = 0x3FFFFFFF;
    private int pendingOutgoingWrites;
    private boolean writeable;
    private long remoteIncomingWindow;
    private int remoteNextIncomingId = this.nextOutgoingId;
    private Runnable outgoingFrameWriteComplete = this::handleOutgoingFrameWriteComplete;
    private final UnsettledMap<ProtonOutgoingDelivery> unsettled = new UnsettledMap<ProtonOutgoingDelivery>(ProtonOutgoingDelivery::getDeliveryIdInt);
    private final Disposition cachedDisposition = new Disposition();
    private final Transfer cachedTransfer = new Transfer();

    public ProtonSessionOutgoingWindow(ProtonSession session) {
        this.session = session;
        this.engine = session.getConnection().getEngine();
        this.localChannel = session.getLocalChannel();
    }

    Begin configureOutbound(Begin begin) {
        begin.setNextOutgoingId(this.getNextOutgoingId());
        begin.setOutgoingWindow(this.getOutgoingWindow());
        this.updateOutgoingWindowState();
        return begin;
    }

    int getAndIncrementNextDeliveryId() {
        return this.outgoingDeliveryId++;
    }

    void setOutgoingCapacity(int outgoingCapacity) {
        this.outgoingCapacity = outgoingCapacity;
        this.updateOutgoingWindowState();
    }

    int getOutgoingCapacity() {
        return this.outgoingCapacity;
    }

    int getRemainingOutgoingCapacity() {
        int allowedWrites = Math.max(0, this.outgoingWindowHighWaterMark - this.pendingOutgoingWrites);
        int remaining = (int)((long)allowedWrites * this.session.getEngine().configuration().getOutboundMaxFrameSize());
        if (this.outgoingCapacity < 0 || remaining < 0) {
            return Integer.MAX_VALUE;
        }
        return remaining;
    }

    boolean isSendable() {
        return this.writeable;
    }

    private void updateOutgoingWindowState() {
        boolean oldWritable = this.writeable;
        int maxFrameSize = (int)this.session.getEngine().configuration().getOutboundMaxFrameSize();
        if (this.outgoingCapacity == 0) {
            this.outgoingWindowLowWaterMark = 0;
            this.outgoingWindowHighWaterMark = 0;
            this.writeable = false;
        } else if (this.outgoingCapacity > 0) {
            this.outgoingWindowHighWaterMark = Math.max(1, this.outgoingCapacity / maxFrameSize);
            this.outgoingWindowLowWaterMark = this.outgoingWindowHighWaterMark / 2;
            this.writeable = this.pendingOutgoingWrites <= this.outgoingWindowLowWaterMark && this.remoteIncomingWindow > 0L;
        } else {
            this.outgoingWindowHighWaterMark = Integer.MAX_VALUE;
            this.outgoingWindowLowWaterMark = 0x3FFFFFFF;
            boolean bl = this.writeable = this.remoteIncomingWindow > 0L;
        }
        if (!oldWritable && this.writeable) {
            Set<ProtonSender> senders = this.session.senders();
            for (ProtonSender sender : senders) {
                sender.handleSessionCreditStateUpdate(this);
                if (this.writeable) continue;
                break;
            }
        }
    }

    private void handleOutgoingFrameWriteComplete() {
        this.pendingOutgoingWrites = Math.max(0, --this.pendingOutgoingWrites);
        if (!this.writeable && (this.writeable = this.pendingOutgoingWrites <= this.outgoingWindowLowWaterMark && this.remoteIncomingWindow > 0L)) {
            Set<ProtonSender> senders = this.session.senders();
            for (ProtonSender sender : senders) {
                sender.handleSessionCreditStateUpdate(this);
                if (this.writeable) continue;
                break;
            }
        }
    }

    Begin handleBegin(Begin begin) {
        this.remoteIncomingWindow = begin.getIncomingWindow();
        return begin;
    }

    Flow handleFlow(Flow flow) {
        if (flow.hasNextIncomingId()) {
            this.remoteNextIncomingId = (int)flow.getNextIncomingId();
            this.remoteIncomingWindow = (long)this.remoteNextIncomingId + flow.getIncomingWindow() - (long)this.nextOutgoingId;
        } else {
            this.remoteIncomingWindow = flow.getIncomingWindow();
        }
        this.writeable = this.remoteIncomingWindow > 0L && this.pendingOutgoingWrites <= this.outgoingWindowLowWaterMark;
        return flow;
    }

    Transfer handleTransfer(Transfer transfer, ProtonBuffer payload) {
        return transfer;
    }

    Disposition handleDisposition(Disposition disposition) {
        int first = (int)disposition.getFirst();
        if (disposition.hasLast() && disposition.getLast() != (long)first) {
            ProtonSessionOutgoingWindow.handleRangedDisposition(this.unsettled, disposition);
        } else {
            ProtonOutgoingDelivery delivery;
            ProtonOutgoingDelivery protonOutgoingDelivery = delivery = disposition.getSettled() ? this.unsettled.remove(first) : this.unsettled.get(first);
            if (delivery != null) {
                delivery.getLink().remoteDisposition(disposition, delivery);
            }
        }
        return disposition;
    }

    private static void handleRangedDisposition(UnsettledMap<ProtonOutgoingDelivery> unsettled, Disposition disposition) {
        if (disposition.getSettled()) {
            unsettled.removeEach((int)disposition.getFirst(), (int)disposition.getLast(), delivery -> delivery.getLink().remoteDisposition(disposition, (ProtonOutgoingDelivery)delivery));
        } else {
            unsettled.forEach((int)disposition.getFirst(), (int)disposition.getLast(), delivery -> delivery.getLink().remoteDisposition(disposition, (ProtonOutgoingDelivery)delivery));
        }
    }

    private static void handlePayloadToLargeRequiresSplitFrames(Performative performative) {
        ((Transfer)performative).setMore(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processSend(ProtonSender sender, ProtonOutgoingDelivery delivery, ProtonBuffer payload, boolean complete) {
        if (!delivery.isSettled()) {
            this.unsettled.put((int)delivery.getDeliveryId(), delivery);
        }
        try {
            this.cachedTransfer.setDeliveryId(delivery.getDeliveryId());
            if (delivery.getMessageFormat() != 0) {
                this.cachedTransfer.setMessageFormat(delivery.getMessageFormat());
            } else {
                this.cachedTransfer.clearMessageFormat();
            }
            this.cachedTransfer.setHandle(sender.getHandle());
            this.cachedTransfer.setSettled(delivery.isSettled());
            this.cachedTransfer.setState(delivery.getState());
            do {
                ++this.nextOutgoingId;
                ++this.pendingOutgoingWrites;
                --this.remoteIncomingWindow;
                boolean bl = this.writeable = this.pendingOutgoingWrites < this.outgoingWindowHighWaterMark && this.remoteIncomingWindow > 0L;
                if (delivery.getTransferCount() == 0) {
                    this.cachedTransfer.setDeliveryTag(delivery.getTag());
                } else {
                    this.cachedTransfer.setDeliveryTag((DeliveryTag)null);
                }
                this.cachedTransfer.setMore(!complete);
                OutgoingAMQPEnvelope frame = this.engine.wrap(this.cachedTransfer, this.localChannel, payload);
                frame.setPayloadToLargeHandler(ProtonSessionOutgoingWindow::handlePayloadToLargeRequiresSplitFrames);
                frame.setFrameWriteCompletionHandler(this.outgoingFrameWriteComplete);
                this.engine.fireWrite(frame);
                delivery.afterTransferWritten();
            } while (payload != null && payload.isReadable() && this.isSendable());
        }
        finally {
            this.cachedTransfer.reset();
        }
        return this.isSendable();
    }

    void processDisposition(ProtonSender sender, ProtonOutgoingDelivery delivery) {
        if (delivery.isSettled() && !delivery.isRemotelySettled()) {
            this.unsettled.remove((int)delivery.getDeliveryId());
        }
        if (!delivery.isRemotelySettled()) {
            this.cachedDisposition.setFirst(delivery.getDeliveryId());
            this.cachedDisposition.setRole(Role.SENDER);
            this.cachedDisposition.setSettled(delivery.isSettled());
            this.cachedDisposition.setState(delivery.getState());
            try {
                this.engine.fireWrite(this.cachedDisposition, this.session.getLocalChannel());
            }
            finally {
                this.cachedDisposition.reset();
            }
        }
    }

    void processAbort(ProtonSender sender, ProtonOutgoingDelivery delivery) {
        this.cachedTransfer.setDeliveryId(delivery.getDeliveryId());
        this.cachedTransfer.setDeliveryTag(delivery.getTag());
        this.cachedTransfer.setSettled(true);
        this.cachedTransfer.setAborted(true);
        this.cachedTransfer.setHandle(sender.getHandle());
        this.unsettled.remove((int)delivery.getDeliveryId());
        try {
            this.engine.fireWrite(this.cachedTransfer, this.session.getLocalChannel());
        }
        finally {
            this.cachedTransfer.reset();
        }
    }

    int getNextOutgoingId() {
        return this.nextOutgoingId;
    }

    long getOutgoingWindow() {
        return Integer.MAX_VALUE;
    }

    int getRemoteNextIncomingId() {
        return this.remoteNextIncomingId;
    }

    long getRemoteIncomingWindow() {
        return this.remoteIncomingWindow;
    }
}

