/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.transport.netty5;

import io.netty5.bootstrap.Bootstrap;
import io.netty5.buffer.Buffer;
import io.netty5.channel.Channel;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.ChannelInitializer;
import io.netty5.channel.ChannelOption;
import io.netty5.channel.ChannelPipeline;
import io.netty5.channel.SimpleChannelInboundHandler;
import io.netty5.handler.logging.LoggingHandler;
import io.netty5.handler.ssl.SslHandler;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.FutureListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.buffer.ProtonBufferAllocator;
import org.apache.qpid.protonj2.buffer.ProtonBufferComponent;
import org.apache.qpid.protonj2.buffer.ProtonBufferComponentAccessor;
import org.apache.qpid.protonj2.buffer.netty.Netty5ProtonBufferAllocator;
import org.apache.qpid.protonj2.buffer.netty.Netty5ToProtonBufferAdapter;
import org.apache.qpid.protonj2.buffer.netty.ProtonBufferToNetty5Adapter;
import org.apache.qpid.protonj2.client.SslOptions;
import org.apache.qpid.protonj2.client.TransportOptions;
import org.apache.qpid.protonj2.client.transport.Transport;
import org.apache.qpid.protonj2.client.transport.TransportListener;
import org.apache.qpid.protonj2.client.transport.netty5.SslSupport;
import org.apache.qpid.protonj2.client.util.IOExceptionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpTransport
implements Transport {
    private static final Logger LOG = LoggerFactory.getLogger(TcpTransport.class);
    protected final AtomicBoolean connected = new AtomicBoolean();
    protected final AtomicBoolean closed = new AtomicBoolean();
    protected final CountDownLatch connectedLatch = new CountDownLatch(1);
    protected final TransportOptions options;
    protected final SslOptions sslOptions;
    protected final Bootstrap bootstrap;
    protected Channel channel;
    protected volatile IOException failureCause;
    protected String host;
    protected int port;
    protected TransportListener listener;
    protected Netty5ProtonBufferAllocator nettyAllocator;

    public TcpTransport(Bootstrap bootstrap, TransportOptions options, SslOptions sslOptions) {
        if (options == null) {
            throw new IllegalArgumentException("Transport Options cannot be null");
        }
        if (sslOptions == null) {
            throw new IllegalArgumentException("Transport SSL Options cannot be null");
        }
        if (bootstrap == null) {
            throw new IllegalArgumentException("A transport must have an assigned Bootstrap before connect.");
        }
        this.sslOptions = sslOptions;
        this.options = options;
        this.bootstrap = bootstrap;
    }

    @Override
    public TcpTransport connect(String host, int port, final TransportListener listener) throws IOException {
        if (this.closed.get()) {
            throw new IllegalStateException("Transport has already been closed");
        }
        if (listener == null) {
            throw new IllegalArgumentException("A transport listener must be set before connection attempts.");
        }
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("Transport host value cannot be null");
        }
        if (port < 0 && this.options.defaultTcpPort() < 0 && this.sslOptions.sslEnabled() && this.sslOptions.defaultSslPort() < 0) {
            throw new IllegalArgumentException("Transport port value must be a non-negative int value or a default port configured");
        }
        this.host = host;
        this.listener = listener;
        this.port = port > 0 ? port : (this.sslOptions.sslEnabled() ? this.sslOptions.defaultSslPort() : this.options.defaultTcpPort());
        this.bootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            public void initChannel(Channel transportChannel) throws Exception {
                TcpTransport.this.channel = transportChannel;
                TcpTransport.this.nettyAllocator = new Netty5ProtonBufferAllocator(TcpTransport.this.channel.bufferAllocator());
                TcpTransport.this.configureChannel(transportChannel);
                try {
                    listener.transportInitialized(TcpTransport.this);
                }
                catch (Throwable initError) {
                    LOG.warn("Error during initialization of channel from Transport Listener");
                    TcpTransport.this.handleTransportFailure(transportChannel, IOExceptionSupport.create(initError));
                    throw initError;
                }
            }
        });
        this.configureNetty(this.bootstrap, this.options);
        this.bootstrap.connect(this.getHost(), this.getPort()).addListener((FutureListener)new FutureListener<Channel>(){

            public void operationComplete(Future<? extends Channel> future) throws Exception {
                if (future.isFailed()) {
                    TcpTransport.this.bootstrap.config().group().execute(() -> TcpTransport.this.handleTransportFailure(TcpTransport.this.channel, future.cause()));
                }
            }
        });
        return this;
    }

    @Override
    public void awaitConnect() throws InterruptedException, IOException {
        this.connectedLatch.await();
        if (!this.connected.get()) {
            if (this.failureCause != null) {
                throw this.failureCause;
            }
            throw new IOException("Transport was closed before a connection was established.");
        }
    }

    @Override
    public boolean isConnected() {
        return this.connected.get();
    }

    @Override
    public boolean isSecure() {
        return this.sslOptions.sslEnabled();
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.connected.set(false);
            this.connectedLatch.countDown();
            if (this.channel != null) {
                try {
                    this.channel.close().asStage().await();
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
            }
        }
    }

    @Override
    public ProtonBufferAllocator getBufferAllocator() {
        return this.nettyAllocator;
    }

    @Override
    public TcpTransport write(ProtonBuffer output) throws IOException {
        return this.write(output, null);
    }

    @Override
    public TcpTransport write(ProtonBuffer output, Runnable onComplete) throws IOException {
        this.checkConnected(output);
        LOG.trace("Attempted write of buffer: {}", (Object)output);
        return this.writeOutputBuffer(output, false, onComplete);
    }

    @Override
    public TcpTransport writeAndFlush(ProtonBuffer output) throws IOException {
        return this.writeAndFlush(output, null);
    }

    @Override
    public TcpTransport writeAndFlush(ProtonBuffer output, Runnable onComplete) throws IOException {
        this.checkConnected(output);
        LOG.trace("Attempted write and flush of buffer: {}", (Object)output);
        return this.writeOutputBuffer(output, true, onComplete);
    }

    @Override
    public TcpTransport flush() throws IOException {
        this.checkConnected();
        LOG.trace("Attempted flush of pending writes");
        this.channel.flush();
        return this;
    }

    @Override
    public TransportListener getTransportListener() {
        return this.listener;
    }

    @Override
    public TransportOptions getTransportOptions() {
        return this.options.clone();
    }

    @Override
    public SslOptions getSslOptions() {
        return this.sslOptions.clone();
    }

    @Override
    public Principal getLocalPrincipal() {
        Principal result = null;
        if (this.isSecure()) {
            SslHandler sslHandler = (SslHandler)this.channel.pipeline().get(SslHandler.class);
            result = sslHandler.engine().getSession().getLocalPrincipal();
        }
        return result;
    }

    private TcpTransport writeOutputBuffer(ProtonBuffer buffer, boolean flush, Runnable onComplete) {
        int writeCount = buffer.componentCount();
        Future writeFuture = null;
        try (ProtonBuffer ioBuffer = buffer;
             ProtonBufferComponentAccessor accessor = buffer.componentAccessor();){
            ProtonBufferComponent output = accessor.firstReadable();
            while (output != null) {
                Buffer nettyBuf;
                if (output instanceof Netty5ToProtonBufferAdapter) {
                    nettyBuf = ((Netty5ToProtonBufferAdapter)output).unwrapAndRelease();
                } else if (output.unwrap() instanceof Buffer) {
                    nettyBuf = ((Buffer)output.unwrap()).copy(true);
                } else {
                    nettyBuf = this.channel.bufferAllocator().allocate(output.getReadableBytes());
                    if (output.hasReadbleArray()) {
                        nettyBuf.writeBytes(output.getReadableArray(), output.getReadableArrayOffset(), output.getReadableBytes());
                    } else {
                        nettyBuf.writeBytes(output.getReadableBuffer());
                    }
                }
                writeFuture = --writeCount == 0 && flush ? this.channel.writeAndFlush((Object)nettyBuf) : this.channel.write((Object)nettyBuf);
                output = accessor.nextReadable();
            }
            if (onComplete != null) {
                writeFuture.addListener((Object)onComplete, TcpTransport::handleWriteComplete);
            }
        }
        return this;
    }

    private TcpTransport writeOutputBufferAsWrappedNettyBuffer(ProtonBuffer buffer, boolean flush, Runnable onComplete) {
        Future writeFuture = null;
        ProtonBufferToNetty5Adapter nettyBuf = new ProtonBufferToNetty5Adapter((ProtonBuffer)buffer.transfer());
        writeFuture = flush ? this.channel.writeAndFlush((Object)nettyBuf) : this.channel.write((Object)nettyBuf);
        if (onComplete != null) {
            writeFuture.addListener((Object)onComplete, TcpTransport::handleWriteComplete);
        }
        return this;
    }

    private static void handleWriteComplete(Runnable onComplete, Future<? extends Void> future) {
        if (future.isSuccess()) {
            onComplete.run();
        }
    }

    protected void addAdditionalHandlers(ChannelPipeline pipeline) {
    }

    protected ChannelHandler createChannelHandler() {
        return new NettyTcpTransportHandler();
    }

    protected void handleConnected(Channel connectedChannel) throws Exception {
        LOG.trace("Channel has become active! Channel is {}", (Object)connectedChannel);
        this.channel = connectedChannel;
        this.connected.set(true);
        this.listener.transportConnected(this);
        this.connectedLatch.countDown();
    }

    protected void handleTransportFailure(Channel failedChannel, Throwable cause) {
        if (!this.closed.get()) {
            LOG.trace("Transport indicates connection failure! Channel is {}", (Object)failedChannel);
            this.failureCause = IOExceptionSupport.create(cause);
            this.channel = failedChannel;
            this.connected.set(false);
            this.connectedLatch.countDown();
            LOG.trace("Firing onTransportError listener");
            if (this.channel.executor().inEventLoop()) {
                this.listener.transportError(this.failureCause);
            } else {
                this.channel.executor().execute(() -> this.listener.transportError(this.failureCause));
            }
        } else {
            LOG.trace("Closed Transport signalled that the channel ended: {}", (Object)this.channel);
        }
    }

    protected final void checkConnected() throws IOException {
        if (!this.connected.get() || !this.channel.isActive()) {
            throw new IOException("Cannot send to a non-connected transport.", this.failureCause);
        }
    }

    private void checkConnected(ProtonBuffer output) throws IOException {
        if (!this.connected.get() || !this.channel.isActive()) {
            output.close();
            throw new IOException("Cannot send to a non-connected transport.", this.failureCause);
        }
    }

    private void configureNetty(Bootstrap bootstrap, TransportOptions options) {
        bootstrap.option(ChannelOption.TCP_NODELAY, (Object)options.tcpNoDelay());
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)options.connectTimeout());
        bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)options.tcpKeepAlive());
        bootstrap.option(ChannelOption.SO_LINGER, (Object)options.soLinger());
        if (options.sendBufferSize() != -1) {
            bootstrap.option(ChannelOption.SO_SNDBUF, (Object)options.sendBufferSize());
        }
        if (options.receiveBufferSize() != -1) {
            bootstrap.option(ChannelOption.SO_RCVBUF, (Object)options.receiveBufferSize());
        }
        if (options.trafficClass() != -1) {
            bootstrap.option(ChannelOption.IP_TOS, (Object)options.trafficClass());
        }
        if (options.localAddress() != null || options.localPort() != 0) {
            if (options.localAddress() != null) {
                bootstrap.localAddress(options.localAddress(), options.localPort());
            } else {
                bootstrap.localAddress(options.localPort());
            }
        }
    }

    private void configureChannel(Channel channel) throws Exception {
        if (this.isSecure()) {
            SslHandler sslHandler;
            try {
                sslHandler = SslSupport.createSslHandler(channel.bufferAllocator(), this.host, this.port, this.sslOptions);
            }
            catch (Exception ex) {
                LOG.warn("Error during initialization of channel from SSL Handler creation:");
                this.handleTransportFailure(channel, IOExceptionSupport.create(ex));
                throw IOExceptionSupport.create(ex);
            }
            channel.pipeline().addLast("ssl", (ChannelHandler)sslHandler);
        }
        if (this.options.traceBytes()) {
            channel.pipeline().addLast("logger", (ChannelHandler)new LoggingHandler(this.getClass()));
        }
        this.addAdditionalHandlers(channel.pipeline());
        channel.pipeline().addLast(new ChannelHandler[]{this.createChannelHandler()});
    }

    @Override
    public URI getRemoteURI() {
        if (this.host != null) {
            try {
                return new URI(this.getScheme(), null, this.host, this.port, null, null, null);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    protected String getScheme() {
        return this.isSecure() ? "ssl" : "tcp";
    }

    protected class NettyTcpTransportHandler
    extends NettyDefaultHandler<Buffer> {
        protected NettyTcpTransportHandler() {
        }

        protected void messageReceived(ChannelHandlerContext ctx, Buffer buffer) throws Exception {
            this.dispatchReadBuffer(buffer);
        }
    }

    protected abstract class NettyDefaultHandler<E>
    extends SimpleChannelInboundHandler<E> {
        public NettyDefaultHandler() {
            super(false);
        }

        public final void channelRegistered(ChannelHandlerContext context) throws Exception {
            TcpTransport.this.channel = context.channel();
        }

        public void channelActive(ChannelHandlerContext context) throws Exception {
            if (!TcpTransport.this.isSecure()) {
                TcpTransport.this.handleConnected(context.channel());
            } else {
                SslHandler sslHandler = (SslHandler)context.pipeline().get(SslHandler.class);
                sslHandler.handshakeFuture().addListener((FutureListener)new FutureListener<Channel>(){

                    public void operationComplete(Future<? extends Channel> future) throws Exception {
                        if (future.isSuccess()) {
                            LOG.trace("SSL Handshake has completed: {}", (Object)TcpTransport.this.channel);
                            TcpTransport.this.handleConnected(TcpTransport.this.channel);
                        } else {
                            LOG.trace("SSL Handshake has failed: {}", (Object)TcpTransport.this.channel);
                            TcpTransport.this.handleTransportFailure(TcpTransport.this.channel, future.cause());
                        }
                    }
                });
            }
        }

        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            ctx.flush();
        }

        public void channelInactive(ChannelHandlerContext context) throws Exception {
            TcpTransport.this.handleTransportFailure(context.channel(), new IOException("Remote closed connection unexpectedly"));
        }

        public void channelExceptionCaught(ChannelHandlerContext context, Throwable cause) throws Exception {
            TcpTransport.this.handleTransportFailure(context.channel(), cause);
        }

        protected void dispatchReadBuffer(Buffer buffer) throws Exception {
            ProtonBuffer wrapped;
            LOG.trace("New data read: {}", (Object)buffer);
            try (ProtonBuffer protonBuffer = wrapped = TcpTransport.this.nettyAllocator.wrap(buffer).convertToReadOnly();){
                TcpTransport.this.listener.transportRead(wrapped);
            }
        }
    }
}

