/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.impl;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.buffer.ProtonBufferAllocator;
import org.apache.qpid.protonj2.client.AdvancedMessage;
import org.apache.qpid.protonj2.client.Message;
import org.apache.qpid.protonj2.client.Sender;
import org.apache.qpid.protonj2.client.SenderOptions;
import org.apache.qpid.protonj2.client.Tracker;
import org.apache.qpid.protonj2.client.exceptions.ClientConnectionRemotelyClosedException;
import org.apache.qpid.protonj2.client.exceptions.ClientException;
import org.apache.qpid.protonj2.client.exceptions.ClientResourceRemotelyClosedException;
import org.apache.qpid.protonj2.client.exceptions.ClientSendTimedOutException;
import org.apache.qpid.protonj2.client.futures.ClientFuture;
import org.apache.qpid.protonj2.client.impl.ClientExceptionSupport;
import org.apache.qpid.protonj2.client.impl.ClientMessageSupport;
import org.apache.qpid.protonj2.client.impl.ClientNoOpTracker;
import org.apache.qpid.protonj2.client.impl.ClientSenderBuilder;
import org.apache.qpid.protonj2.client.impl.ClientSenderLinkType;
import org.apache.qpid.protonj2.client.impl.ClientSession;
import org.apache.qpid.protonj2.client.impl.ClientTrackable;
import org.apache.qpid.protonj2.client.impl.ClientTracker;
import org.apache.qpid.protonj2.client.impl.ClientTransactionContext;
import org.apache.qpid.protonj2.engine.OutgoingDelivery;
import org.apache.qpid.protonj2.types.transport.DeliveryState;
import org.apache.qpid.protonj2.types.transport.SenderSettleMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientSender
extends ClientSenderLinkType<Sender>
implements Sender {
    private static final Logger LOG = LoggerFactory.getLogger(ClientSender.class);
    private final Deque<ClientOutgoingEnvelope> blocked = new ArrayDeque<ClientOutgoingEnvelope>();
    private final SenderOptions options;

    ClientSender(ClientSession session, SenderOptions options, String senderId, org.apache.qpid.protonj2.engine.Sender protonSender) {
        super(session, senderId, options, protonSender);
        this.options = new SenderOptions(options);
    }

    @Override
    public Tracker send(Message<?> message) throws ClientException {
        this.checkClosedOrFailed();
        return this.sendMessage(ClientMessageSupport.convertMessage(message), null, true);
    }

    @Override
    public Tracker send(Message<?> message, Map<String, Object> deliveryAnnotations) throws ClientException {
        this.checkClosedOrFailed();
        return this.sendMessage(ClientMessageSupport.convertMessage(message), deliveryAnnotations, true);
    }

    @Override
    public Tracker trySend(Message<?> message) throws ClientException {
        this.checkClosedOrFailed();
        return this.sendMessage(ClientMessageSupport.convertMessage(message), null, false);
    }

    @Override
    public Tracker trySend(Message<?> message, Map<String, Object> deliveryAnnotations) throws ClientException {
        this.checkClosedOrFailed();
        return this.sendMessage(ClientMessageSupport.convertMessage(message), deliveryAnnotations, false);
    }

    SenderOptions options() {
        return this.options;
    }

    @Override
    void disposition(OutgoingDelivery delivery, DeliveryState state, boolean settled) throws ClientException {
        this.checkClosedOrFailed();
        this.executor.execute(() -> delivery.disposition(state, settled));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCreditStateUpdated(org.apache.qpid.protonj2.engine.Sender sender) {
        if (!this.blocked.isEmpty()) {
            ClientOutgoingEnvelope held;
            while (sender.isSendable() && !this.blocked.isEmpty() && (held = this.blocked.peek()).delivery() == this.protonSender.current()) {
                LOG.trace("Dispatching previously held send");
                try {
                    this.session.getTransactionContext().send(held, null, this.isSendingSettled());
                }
                catch (Exception error) {
                    held.failed(ClientExceptionSupport.createNonFatalOrPassthrough(error));
                }
                finally {
                    this.blocked.poll();
                }
            }
        }
        if (sender.isDraining() && sender.current() == null && this.blocked.isEmpty()) {
            sender.drained();
        }
    }

    @Override
    protected Sender self() {
        return this;
    }

    private void addToTailOfBlockedQueue(ClientOutgoingEnvelope send) {
        if (this.options.sendTimeout() > 0L && send.sendTimeout() == null) {
            send.sendTimeout(this.executor.schedule(() -> send.failed(send.createSendTimedOutException()), this.options.sendTimeout(), TimeUnit.MILLISECONDS));
        }
        this.blocked.addLast(send);
    }

    private void addToHeadOfBlockedQueue(ClientOutgoingEnvelope send) {
        if (this.options.sendTimeout() > 0L && send.sendTimeout() == null) {
            send.sendTimeout(this.executor.schedule(() -> send.failed(send.createSendTimedOutException()), this.options.sendTimeout(), TimeUnit.MILLISECONDS));
        }
        this.blocked.addFirst(send);
    }

    private Tracker sendMessage(AdvancedMessage<?> message, Map<String, Object> deliveryAnnotations, boolean waitForCredit) throws ClientException {
        ClientFuture operation = this.session.getFutureFactory().createFuture();
        ProtonBuffer buffer = message.encode(deliveryAnnotations, ProtonBufferAllocator.defaultAllocator());
        this.executor.execute(() -> {
            if (this.notClosedOrFailed(operation)) {
                try {
                    ClientOutgoingEnvelope envelope = new ClientOutgoingEnvelope(this, message.messageFormat(), buffer, operation);
                    if (this.protonSender.isSendable() && this.protonSender.current() == null) {
                        this.session.getTransactionContext().send(envelope, null, this.protonSender.getSenderSettleMode() == SenderSettleMode.SETTLED);
                    } else if (waitForCredit) {
                        this.addToTailOfBlockedQueue(envelope);
                    } else {
                        operation.complete(null);
                    }
                }
                catch (Exception error) {
                    operation.failed(ClientExceptionSupport.createNonFatalOrPassthrough(error));
                }
            }
        });
        return (Tracker)this.session.request(this, operation);
    }

    private Tracker createTracker(OutgoingDelivery delivery) {
        return new ClientTracker(this, delivery);
    }

    private Tracker createNoOpTracker() {
        return new ClientNoOpTracker(this);
    }

    @Override
    protected void linkSpecificLocalOpenHandler() {
        this.protonSender.creditStateUpdateHandler(this::handleCreditStateUpdated);
    }

    @Override
    protected void recreateLinkForReconnect() {
        this.protonSender.localCloseHandler(null);
        this.protonSender.localDetachHandler(null);
        this.protonSender.close();
        if (this.protonSender.hasUnsettled()) {
            this.failPendingUnsettledAndBlockedSends(new ClientConnectionRemotelyClosedException("Connection failed and send result is unknown"));
        }
        this.protonSender = ClientSenderBuilder.recreateSender(this.session, this.protonSender, this.options);
        this.protonSender.setLinkedResource((Object)this);
    }

    @Override
    protected void linkSpecificCleanupHandler(ClientException failureCause) {
        if (failureCause != null) {
            this.failPendingUnsettledAndBlockedSends(failureCause);
        } else {
            this.failPendingUnsettledAndBlockedSends(new ClientResourceRemotelyClosedException("The sender link has closed"));
        }
    }

    private void failPendingUnsettledAndBlockedSends(ClientException cause) {
        this.protonSender.unsettled().forEach(delivery -> {
            try {
                ((ClientTrackable)delivery.getLinkedResource(ClientTrackable.class)).settlementFuture().failed(cause);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.blocked.removeIf(held -> {
            held.failed(cause);
            return true;
        });
    }

    @Override
    protected void linkSpecificLocalCloseHandler() {
    }

    @Override
    protected void linkSpecificRemoteOpenHandler() {
    }

    @Override
    protected void linkSpecificRemoteCloseHandler() {
    }

    private static final class ClientOutgoingEnvelope
    implements ClientTransactionContext.Sendable {
        private final ProtonBuffer payload;
        private final ClientFuture<Tracker> request;
        private final ClientSender sender;
        private final int messageFormat;
        private Future<?> sendTimeout;
        private OutgoingDelivery delivery;

        ClientOutgoingEnvelope(ClientSender sender, int messageFormat, ProtonBuffer payload, ClientFuture<Tracker> request) {
            this.messageFormat = messageFormat;
            this.payload = payload;
            this.request = request;
            this.sender = sender;
        }

        public Future<?> sendTimeout() {
            return this.sendTimeout;
        }

        public void sendTimeout(Future<?> sendTimeout) {
            this.sendTimeout = sendTimeout;
        }

        public OutgoingDelivery delivery() {
            return this.delivery;
        }

        public ClientOutgoingEnvelope succeeded() {
            if (this.sendTimeout != null) {
                this.sendTimeout.cancel(true);
            }
            this.payload.close();
            this.request.complete((Tracker)this.delivery.getLinkedResource());
            return this;
        }

        public ClientOutgoingEnvelope failed(ClientException exception) {
            if (this.sendTimeout != null) {
                this.sendTimeout.cancel(true);
            }
            this.payload.close();
            this.request.failed(exception);
            return this;
        }

        @Override
        public void discard() {
            if (this.sendTimeout != null) {
                this.sendTimeout.cancel(true);
                this.sendTimeout = null;
            }
            try (ProtonBuffer protonBuffer = this.payload;){
                if (this.delivery != null) {
                    ClientTracker tracker = (ClientTracker)this.delivery.getLinkedResource();
                    if (tracker != null) {
                        ((ClientFuture)tracker.settlementFuture()).complete(tracker);
                    }
                    this.request.complete((Tracker)this.delivery.getLinkedResource());
                } else {
                    this.request.complete(this.sender.createNoOpTracker());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void send(DeliveryState state, boolean settled) {
            if (this.delivery == null) {
                this.delivery = this.sender.protonLink().next();
                this.delivery.setLinkedResource((Object)this.sender.createTracker(this.delivery));
                this.delivery.setMessageFormat(this.messageFormat);
                this.delivery.disposition(state, settled);
            }
            boolean wasAutoFlushOn = this.sender.connection().autoFlushOff();
            try {
                this.delivery.streamBytes(this.payload, true);
                if (this.payload != null && this.payload.isReadable()) {
                    this.sender.addToHeadOfBlockedQueue(this);
                } else {
                    this.succeeded();
                }
            }
            finally {
                if (wasAutoFlushOn) {
                    this.sender.connection().flush();
                    this.sender.connection().autoFlushOn();
                }
            }
        }

        public ClientException createSendTimedOutException() {
            return new ClientSendTimedOutException("Timed out waiting for credit to send");
        }
    }
}

