/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.types.messaging;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.buffer.impl.ProtonByteArrayBufferAllocator;
import org.apache.qpid.protonj2.types.Binary;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.messaging.Section;

public final class Data
implements Section<byte[]> {
    public static final UnsignedLong DESCRIPTOR_CODE = UnsignedLong.valueOf(117L);
    public static final Symbol DESCRIPTOR_SYMBOL = Symbol.valueOf("amqp:data:binary");
    private final ProtonBuffer buffer;
    private Binary cachedBinary;

    public Data(Binary binary) {
        this.buffer = binary != null ? binary.asProtonBuffer() : null;
        this.cachedBinary = binary;
    }

    public Data(ProtonBuffer buffer) {
        this.buffer = buffer != null ? buffer.convertToReadOnly() : null;
    }

    public Data(byte[] value) {
        this.buffer = value != null ? ProtonByteArrayBufferAllocator.wrapped(value, 0, value.length).convertToReadOnly() : null;
    }

    public Data(byte[] value, int offset, int length) {
        this.buffer = value != null ? ProtonByteArrayBufferAllocator.wrapped(value, offset, length).convertToReadOnly() : null;
    }

    public Data copy() {
        return new Data(this.buffer == null ? null : this.buffer.copy(true));
    }

    public Binary getBinary() {
        if (this.cachedBinary != null || this.buffer == null) {
            return this.cachedBinary;
        }
        this.cachedBinary = new Binary(this.buffer.copy(true));
        return this.cachedBinary;
    }

    public int getDataLength() {
        return this.buffer == null ? 0 : this.buffer.getReadableBytes();
    }

    public ProtonBuffer getBuffer() {
        return this.buffer == null ? null : this.buffer.copy(true);
    }

    public Data copyTo(ProtonBuffer target) {
        if (this.buffer != null) {
            this.buffer.copyInto(this.buffer.getReadOffset(), target, target.getWriteOffset(), this.buffer.getReadableBytes());
            target.advanceWriteOffset(this.buffer.getReadableBytes());
        }
        return this;
    }

    @Override
    public byte[] getValue() {
        byte[] dataCopy = null;
        if (this.buffer != null) {
            dataCopy = new byte[this.buffer.getReadableBytes()];
            this.buffer.copyInto(this.buffer.getReadOffset(), dataCopy, 0, dataCopy.length);
        }
        return dataCopy;
    }

    public String toString() {
        if (this.buffer == null) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        str.append("Data{ ");
        for (int i = 0; i < this.buffer.getReadableBytes(); ++i) {
            byte c = this.buffer.getByte(i);
            if (c > 31 && c < 127 && c != 92) {
                str.append((char)c);
                continue;
            }
            str.append(String.format("\\x%02x", c));
        }
        str.append(" }");
        return str.toString();
    }

    @Override
    public Section.SectionType getType() {
        return Section.SectionType.Data;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.buffer == null ? 0 : this.buffer.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Data other = (Data)obj;
        if (this.buffer == null) {
            return other.buffer == null;
        }
        return this.buffer.equals(other.buffer);
    }
}

