/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.encoders.primitives;

import java.util.List;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.EncodeException;
import org.apache.qpid.protonj2.codec.EncoderState;
import org.apache.qpid.protonj2.codec.TypeEncoder;
import org.apache.qpid.protonj2.codec.encoders.AbstractPrimitiveTypeEncoder;

public final class ListTypeEncoder
extends AbstractPrimitiveTypeEncoder<List> {
    @Override
    public Class<List> getTypeClass() {
        return List.class;
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, List value) {
        if (value.isEmpty()) {
            buffer.writeByte((byte)69);
        } else {
            buffer.writeByte((byte)-48);
            this.writeValue(buffer, state, value);
        }
    }

    @Override
    public void writeRawArray(ProtonBuffer buffer, EncoderState state, Object[] values) {
        buffer.writeByte((byte)-48);
        for (Object value : values) {
            this.writeValue(buffer, state, (List)value);
        }
    }

    private void writeValue(ProtonBuffer buffer, EncoderState state, List value) {
        int startIndex = buffer.getWriteOffset();
        buffer.writeInt(0);
        buffer.writeInt(value.size());
        TypeEncoder<?> encoder = null;
        for (int i = 0; i < value.size(); ++i) {
            Object entry = value.get(i);
            if (encoder == null || !encoder.getTypeClass().equals(entry.getClass())) {
                encoder = state.getEncoder().getTypeEncoder(entry);
            }
            if (encoder == null) {
                throw new EncodeException("Cannot find encoder for type " + entry);
            }
            encoder.writeType(buffer, state, entry);
        }
        int endIndex = buffer.getWriteOffset();
        buffer.setInt(startIndex, endIndex - startIndex - 4);
    }
}

