/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.decoders.transport;

import java.io.InputStream;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.DecodeException;
import org.apache.qpid.protonj2.codec.Decoder;
import org.apache.qpid.protonj2.codec.DecoderState;
import org.apache.qpid.protonj2.codec.StreamDecoder;
import org.apache.qpid.protonj2.codec.StreamDecoderState;
import org.apache.qpid.protonj2.codec.StreamTypeDecoder;
import org.apache.qpid.protonj2.codec.TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.AbstractDescribedTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.ProtonStreamUtils;
import org.apache.qpid.protonj2.codec.decoders.primitives.ListTypeDecoder;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.transport.Detach;
import org.apache.qpid.protonj2.types.transport.ErrorCondition;

public final class DetachTypeDecoder
extends AbstractDescribedTypeDecoder<Detach> {
    private static final int MIN_DETACH_LIST_ENTRIES = 1;
    private static final int MAX_DETACH_LIST_ENTRIES = 3;

    @Override
    public Class<Detach> getTypeClass() {
        return Detach.class;
    }

    @Override
    public UnsignedLong getDescriptorCode() {
        return Detach.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Detach.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Detach readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        return this.readDetach(buffer, state.getDecoder(), state, (ListTypeDecoder)DetachTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Detach[] readArrayElements(ProtonBuffer buffer, DecoderState state, int count) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        Detach[] result = new Detach[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readDetach(buffer, state.getDecoder(), state, (ListTypeDecoder)DetachTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    @Override
    public void skipValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        DetachTypeDecoder.checkIsExpectedType(ListTypeDecoder.class, decoder);
        decoder.skipValue(buffer, state);
    }

    private Detach readDetach(ProtonBuffer buffer, Decoder decoder, DecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Detach detach = new Detach();
        int size = listDecoder.readSize(buffer);
        int count = listDecoder.readCount(buffer);
        if (count < 1) {
            throw new DecodeException("The handle field is mandatory");
        }
        if (count > 3) {
            throw new DecodeException("To many entries in Detach list encoding: " + count);
        }
        block5: for (int index = 0; index < count; ++index) {
            boolean nullValue;
            boolean bl = nullValue = buffer.getByte(buffer.getReadOffset()) == 64;
            if (nullValue) {
                if (index == 0) {
                    throw new DecodeException("The handle field is mandatory in a Detach");
                }
                buffer.advanceReadOffset(1);
                continue;
            }
            switch (index) {
                case 0: {
                    detach.setHandle(decoder.readUnsignedInteger(buffer, state, 0L));
                    continue block5;
                }
                case 1: {
                    detach.setClosed(decoder.readBoolean(buffer, state, false));
                    continue block5;
                }
                case 2: {
                    detach.setError(decoder.readObject(buffer, state, ErrorCondition.class));
                }
            }
        }
        return detach;
    }

    @Override
    public Detach readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        return this.readDetach(stream, state.getDecoder(), state, (ListTypeDecoder)DetachTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Detach[] readArrayElements(InputStream stream, StreamDecoderState state, int count) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        Detach[] result = new Detach[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readDetach(stream, state.getDecoder(), state, (ListTypeDecoder)DetachTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    @Override
    public void skipValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        DetachTypeDecoder.checkIsExpectedType(ListTypeDecoder.class, decoder);
        decoder.skipValue(stream, state);
    }

    private Detach readDetach(InputStream stream, StreamDecoder decoder, StreamDecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Detach detach = new Detach();
        int size = listDecoder.readSize(stream);
        int count = listDecoder.readCount(stream);
        if (count < 1) {
            throw new DecodeException("The handle field is mandatory in a Detach");
        }
        if (count > 3) {
            throw new DecodeException("To many entries in Detach list encoding: " + count);
        }
        block5: for (int index = 0; index < count; ++index) {
            if (stream.markSupported()) {
                boolean nullValue;
                stream.mark(1);
                boolean bl = nullValue = ProtonStreamUtils.readByte(stream) == 64;
                if (nullValue) {
                    if (index != 0) continue;
                    throw new DecodeException("The handle field is mandatory");
                }
                ProtonStreamUtils.reset(stream);
            }
            switch (index) {
                case 0: {
                    detach.setHandle(decoder.readUnsignedInteger(stream, state, 0L));
                    continue block5;
                }
                case 1: {
                    detach.setClosed(decoder.readBoolean(stream, state, false));
                    continue block5;
                }
                case 2: {
                    detach.setError(decoder.readObject(stream, state, ErrorCondition.class));
                }
            }
        }
        return detach;
    }
}

