/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.decoders.primitives;

import java.io.InputStream;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.DecodeException;
import org.apache.qpid.protonj2.codec.DecoderState;
import org.apache.qpid.protonj2.codec.StreamDecoderState;
import org.apache.qpid.protonj2.codec.decoders.AbstractPrimitiveTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.ProtonStreamUtils;

public final class Integer8TypeDecoder
extends AbstractPrimitiveTypeDecoder<Integer> {
    @Override
    public Class<Integer> getTypeClass() {
        return Integer.class;
    }

    @Override
    public int getTypeCode() {
        return 84;
    }

    @Override
    public boolean isJavaPrimitive() {
        return true;
    }

    public int readPrimitiveValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        return buffer.readByte();
    }

    public int readPrimitiveValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        return ProtonStreamUtils.readByte(stream);
    }

    @Override
    public Integer readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        return buffer.readByte() & 0xFF;
    }

    @Override
    public Integer readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        return ProtonStreamUtils.readByte(stream);
    }

    @Override
    public void skipValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        buffer.advanceReadOffset(1);
    }

    @Override
    public void skipValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        ProtonStreamUtils.skipBytes(stream, 1L);
    }
}

