/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.decoders.primitives;

import java.io.InputStream;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.DecodeException;
import org.apache.qpid.protonj2.codec.DecoderState;
import org.apache.qpid.protonj2.codec.StreamDecoderState;
import org.apache.qpid.protonj2.codec.decoders.AbstractPrimitiveTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.ProtonStreamUtils;

public final class FloatTypeDecoder
extends AbstractPrimitiveTypeDecoder<Float> {
    @Override
    public boolean isJavaPrimitive() {
        return true;
    }

    @Override
    public Class<Float> getTypeClass() {
        return Float.class;
    }

    @Override
    public int getTypeCode() {
        return 114;
    }

    @Override
    public Float readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        return Float.valueOf(buffer.readFloat());
    }

    @Override
    public Float readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        return Float.valueOf(ProtonStreamUtils.readFloat(stream));
    }

    public float readPrimitiveValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        return buffer.readFloat();
    }

    public float readPrimitiveValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        return ProtonStreamUtils.readFloat(stream);
    }

    @Override
    public void skipValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        buffer.advanceReadOffset(4);
    }

    @Override
    public void skipValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        ProtonStreamUtils.skipBytes(stream, 4L);
    }
}

