/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.decoders.primitives;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.DecodeException;
import org.apache.qpid.protonj2.codec.Decoder;
import org.apache.qpid.protonj2.codec.DecoderState;
import org.apache.qpid.protonj2.codec.StreamDecoder;
import org.apache.qpid.protonj2.codec.StreamDecoderState;
import org.apache.qpid.protonj2.codec.decoders.AbstractPrimitiveTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.ListTypeDecoder;

public abstract class AbstractListTypeDecoder
extends AbstractPrimitiveTypeDecoder<List>
implements ListTypeDecoder {
    @Override
    public List<Object> readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        int size = this.readSize(buffer);
        if (size > buffer.getReadableBytes()) {
            throw new DecodeException(String.format("List element size %d is specified to be greater than the amount of data available (%d)", size, buffer.getReadableBytes()));
        }
        int count = this.readCount(buffer);
        if (count > buffer.getReadableBytes()) {
            throw new DecodeException(String.format("Symbol encoded element count %d is specified to be greater than the amount of data available (%d)", count, buffer.getReadableBytes()));
        }
        ArrayList<Object> list = new ArrayList<Object>(count);
        Decoder decoder = state.getDecoder();
        for (int i = 0; i < count; ++i) {
            list.add(decoder.readObject(buffer, state));
        }
        return list;
    }

    @Override
    public void skipValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        buffer.advanceReadOffset(this.readSize(buffer));
    }

    @Override
    public List<Object> readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        this.readSize(stream);
        int count = this.readCount(stream);
        ArrayList<Object> list = new ArrayList<Object>(count);
        StreamDecoder decoder = state.getDecoder();
        for (int i = 0; i < count; ++i) {
            list.add(decoder.readObject(stream, state));
        }
        return list;
    }

    @Override
    public void skipValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        try {
            stream.skip(this.readSize(stream));
        }
        catch (IOException ex) {
            throw new DecodeException("Error while reading List payload bytes", ex);
        }
    }
}

