/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.buffer;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.qpid.protonj2.buffer.ProtonBufferComponent;

public interface ProtonBufferComponentAccessor
extends AutoCloseable {
    @Override
    public void close();

    public ProtonBufferComponent first();

    default public ProtonBufferComponent firstReadable() {
        ProtonBufferComponent current = this.first();
        if (current != null && current.getReadableBytes() == 0) {
            return this.nextReadable();
        }
        return current;
    }

    default public ProtonBufferComponent firstWritable() {
        ProtonBufferComponent current = this.first();
        if (current != null && current.getWritableBytes() == 0) {
            return this.nextWritable();
        }
        return current;
    }

    public ProtonBufferComponent next();

    default public ProtonBufferComponent nextReadable() {
        return ProtonBufferComponentAccessor.nextReadableComponent(this);
    }

    default public ProtonBufferComponent nextWritable() {
        return ProtonBufferComponentAccessor.nextWritableComponent(this);
    }

    default public Iterator<ProtonBufferComponent> componentIterator() {
        return new Iterator<ProtonBufferComponent>(){
            private ProtonBufferComponent next;
            {
                this.next = ProtonBufferComponentAccessor.this.first();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public ProtonBufferComponent next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                ProtonBufferComponent oldNext = this.next;
                this.next = ProtonBufferComponentAccessor.this.next();
                return oldNext;
            }
        };
    }

    default public Iterator<ProtonBufferComponent> readableComponentIterator() {
        return new Iterator<ProtonBufferComponent>(){
            private ProtonBufferComponent next;
            {
                this.next = ProtonBufferComponentAccessor.this.firstReadable();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public ProtonBufferComponent next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                ProtonBufferComponent oldNext = this.next;
                this.next = ProtonBufferComponentAccessor.this.nextReadable();
                return oldNext;
            }
        };
    }

    default public Iterator<ProtonBufferComponent> writableComponentIterator() {
        return new Iterator<ProtonBufferComponent>(){
            private ProtonBufferComponent next;
            {
                this.next = ProtonBufferComponentAccessor.this.firstWritable();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public ProtonBufferComponent next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                ProtonBufferComponent oldNext = this.next;
                this.next = ProtonBufferComponentAccessor.this.nextWritable();
                return oldNext;
            }
        };
    }

    private static ProtonBufferComponent nextReadableComponent(ProtonBufferComponentAccessor accessor) {
        ProtonBufferComponent component = accessor.next();
        while (component != null && component.getReadableBytes() == 0) {
            component = accessor.next();
        }
        return component;
    }

    private static ProtonBufferComponent nextWritableComponent(ProtonBufferComponentAccessor accessor) {
        ProtonBufferComponent component = accessor.next();
        while (component != null && component.getWritableBytes() == 0) {
            component = accessor.next();
        }
        return component;
    }
}

