/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.types;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.buffer.ProtonByteBuffer;
import org.apache.qpid.protonj2.buffer.ProtonByteBufferAllocator;

public final class Symbol
implements Comparable<Symbol> {
    private static final Map<ProtonBuffer, Symbol> bufferToSymbols = new ConcurrentHashMap<ProtonBuffer, Symbol>(2048);
    private static final Map<String, Symbol> stringToSymbols = new ConcurrentHashMap<String, Symbol>(2048);
    private static final Symbol EMPTY_SYMBOL = new Symbol();
    private static final int MAX_CACHED_SYMBOL_SIZE = 64;
    private String symbolString;
    private final ProtonBuffer underlying;
    private final int hashCode;

    private Symbol() {
        this.underlying = ProtonByteBufferAllocator.DEFAULT.allocate(0, 0);
        this.hashCode = 31;
        this.symbolString = "";
    }

    private Symbol(ProtonBuffer underlying) {
        this.underlying = underlying;
        this.hashCode = underlying.hashCode();
    }

    public int getLength() {
        return this.underlying.getReadableBytes();
    }

    @Override
    public int compareTo(Symbol other) {
        return this.underlying.compareTo(other.underlying);
    }

    public String toString() {
        if (this.symbolString == null && this.underlying.getReadableBytes() > 0) {
            Symbol existing;
            this.symbolString = this.underlying.toString(StandardCharsets.US_ASCII);
            if (this.underlying.getReadableBytes() <= 64 && (existing = stringToSymbols.putIfAbsent(this.symbolString, this)) != null) {
                this.symbolString = existing.symbolString;
            }
        }
        return this.symbolString;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Symbol) {
            return this.underlying.equals(((Symbol)other).underlying);
        }
        return false;
    }

    public void writeTo(ProtonBuffer target) {
        target.writeBytes(this.underlying, 0, this.underlying.getReadableBytes());
    }

    public static Symbol valueOf(String symbolVal) {
        return Symbol.getSymbol(symbolVal);
    }

    public static Symbol getSymbol(ProtonBuffer symbolBytes) {
        return Symbol.getSymbol(symbolBytes, false);
    }

    public static Symbol getSymbol(ProtonBuffer symbolBuffer, boolean copyOnCreate) {
        if (symbolBuffer == null) {
            return null;
        }
        if (symbolBuffer.getReadableBytes() == 0) {
            return EMPTY_SYMBOL;
        }
        Symbol symbol = bufferToSymbols.get(symbolBuffer);
        if (symbol == null) {
            Symbol existing;
            if (copyOnCreate) {
                int symbolSize = symbolBuffer.getReadableBytes();
                ProtonByteBuffer copy = ProtonByteBufferAllocator.DEFAULT.allocate(symbolSize, symbolSize);
                symbolBuffer = copy.setBytes(0, symbolBuffer, 0, symbolSize).setWriteIndex(symbolSize);
            }
            symbol = new Symbol(symbolBuffer);
            if (symbolBuffer.getReadableBytes() <= 64 && (existing = bufferToSymbols.putIfAbsent(symbolBuffer, symbol)) != null) {
                symbol = existing;
            }
        }
        return symbol;
    }

    public static Symbol getSymbol(String stringValue) {
        if (stringValue == null) {
            return null;
        }
        if (stringValue.isEmpty()) {
            return EMPTY_SYMBOL;
        }
        Symbol symbol = stringToSymbols.get(stringValue);
        if (symbol == null) {
            symbol = Symbol.getSymbol(ProtonByteBufferAllocator.DEFAULT.wrap(stringValue.getBytes(StandardCharsets.US_ASCII)));
            if (symbol.underlying.getReadableBytes() <= 64) {
                stringToSymbols.put(stringValue, symbol);
            }
        }
        return symbol;
    }
}

