/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.encoders.transport;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.Encoder;
import org.apache.qpid.protonj2.codec.EncoderState;
import org.apache.qpid.protonj2.codec.encoders.AbstractDescribedListTypeEncoder;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.transport.Attach;

public final class AttachTypeEncoder
extends AbstractDescribedListTypeEncoder<Attach> {
    @Override
    public UnsignedLong getDescriptorCode() {
        return Attach.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Attach.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Class<Attach> getTypeClass() {
        return Attach.class;
    }

    @Override
    public void writeElement(Attach attach, int index, ProtonBuffer buffer, Encoder encoder, EncoderState state) {
        block17: {
            block16: {
                if (!attach.hasElement(index)) break block16;
                switch (index) {
                    case 0: {
                        encoder.writeString(buffer, state, attach.getName());
                        break block17;
                    }
                    case 1: {
                        encoder.writeUnsignedInteger(buffer, state, attach.getHandle());
                        break block17;
                    }
                    case 2: {
                        buffer.writeByte(attach.getRole().encodingCode());
                        break block17;
                    }
                    case 3: {
                        encoder.writeUnsignedByte(buffer, state, attach.getSenderSettleMode().byteValue());
                        break block17;
                    }
                    case 4: {
                        encoder.writeUnsignedByte(buffer, state, attach.getReceiverSettleMode().byteValue());
                        break block17;
                    }
                    case 5: {
                        encoder.writeObject(buffer, state, attach.getSource());
                        break block17;
                    }
                    case 6: {
                        encoder.writeObject(buffer, state, attach.getTarget());
                        break block17;
                    }
                    case 7: {
                        encoder.writeMap(buffer, state, attach.getUnsettled());
                        break block17;
                    }
                    case 8: {
                        buffer.writeByte(attach.getIncompleteUnsettled() ? 65 : 66);
                        break block17;
                    }
                    case 9: {
                        encoder.writeUnsignedInteger(buffer, state, attach.getInitialDeliveryCount());
                        break block17;
                    }
                    case 10: {
                        encoder.writeUnsignedLong(buffer, state, attach.getMaxMessageSize());
                        break block17;
                    }
                    case 11: {
                        encoder.writeArray(buffer, state, attach.getOfferedCapabilities());
                        break block17;
                    }
                    case 12: {
                        encoder.writeArray(buffer, state, attach.getDesiredCapabilities());
                        break block17;
                    }
                    case 13: {
                        encoder.writeMap(buffer, state, attach.getProperties());
                        break block17;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown Attach value index: " + index);
                    }
                }
            }
            buffer.writeByte(64);
        }
    }

    @Override
    public byte getListEncoding(Attach value) {
        return -48;
    }

    @Override
    public int getElementCount(Attach attach) {
        return attach.getElementCount();
    }

    @Override
    public int getMinElementCount() {
        return 3;
    }
}

