/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.encoders.messaging;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.EncoderState;
import org.apache.qpid.protonj2.codec.TypeEncoder;
import org.apache.qpid.protonj2.codec.encoders.AbstractDescribedTypeEncoder;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.messaging.AmqpValue;

public final class AmqpValueTypeEncoder
extends AbstractDescribedTypeEncoder<AmqpValue> {
    private static final byte[] VALUE_PREAMBLE = new byte[]{0, 83, AmqpValue.DESCRIPTOR_CODE.byteValue()};

    @Override
    public Class<AmqpValue> getTypeClass() {
        return AmqpValue.class;
    }

    @Override
    public UnsignedLong getDescriptorCode() {
        return AmqpValue.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return AmqpValue.DESCRIPTOR_SYMBOL;
    }

    @Override
    public void writeType(ProtonBuffer buffer, EncoderState state, AmqpValue value) {
        buffer.writeBytes(VALUE_PREAMBLE);
        state.getEncoder().writeObject(buffer, state, value.getValue());
    }

    @Override
    public void writeArray(ProtonBuffer buffer, EncoderState state, Object[] values) {
        buffer.writeByte(-16);
        int startIndex = buffer.getWriteIndex();
        buffer.writeInt(0);
        buffer.writeInt(values.length);
        this.writeRawArray(buffer, state, values);
        int endIndex = buffer.getWriteIndex();
        long writeSize = endIndex - startIndex - 4;
        if (writeSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot encode given array, encoded size to large: " + writeSize);
        }
        buffer.setInt(startIndex, (int)writeSize);
    }

    @Override
    public void writeRawArray(ProtonBuffer buffer, EncoderState state, Object[] values) {
        buffer.writeByte(0);
        state.getEncoder().writeUnsignedLong(buffer, state, this.getDescriptorCode());
        Object[] elements = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            AmqpValue value = (AmqpValue)values[i];
            elements[i] = value.getValue();
        }
        TypeEncoder<?> entryEncoder = state.getEncoder().getTypeEncoder(elements[0].getClass());
        entryEncoder.writeRawArray(buffer, state, elements);
    }
}

