/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.decoders.transport;

import java.io.InputStream;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.DecodeException;
import org.apache.qpid.protonj2.codec.Decoder;
import org.apache.qpid.protonj2.codec.DecoderState;
import org.apache.qpid.protonj2.codec.StreamDecoder;
import org.apache.qpid.protonj2.codec.StreamDecoderState;
import org.apache.qpid.protonj2.codec.StreamTypeDecoder;
import org.apache.qpid.protonj2.codec.TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.AbstractDescribedTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.ProtonStreamUtils;
import org.apache.qpid.protonj2.codec.decoders.primitives.ListTypeDecoder;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.transport.Begin;

public final class BeginTypeDecoder
extends AbstractDescribedTypeDecoder<Begin> {
    private static final int MIN_BEGIN_LIST_ENTRIES = 4;
    private static final int MAX_BEGIN_LIST_ENTRIES = 8;

    @Override
    public Class<Begin> getTypeClass() {
        return Begin.class;
    }

    @Override
    public UnsignedLong getDescriptorCode() {
        return Begin.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Begin.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Begin readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        return this.readBegin(buffer, state.getDecoder(), state, (ListTypeDecoder)BeginTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Begin[] readArrayElements(ProtonBuffer buffer, DecoderState state, int count) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        Begin[] result = new Begin[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readBegin(buffer, state.getDecoder(), state, (ListTypeDecoder)BeginTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    @Override
    public void skipValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        BeginTypeDecoder.checkIsExpectedType(ListTypeDecoder.class, decoder);
        decoder.skipValue(buffer, state);
    }

    private Begin readBegin(ProtonBuffer buffer, Decoder decoder, DecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Begin begin = new Begin();
        int size = listDecoder.readSize(buffer);
        int count = listDecoder.readCount(buffer);
        if (count < 4) {
            throw new DecodeException(this.errorForMissingRequiredFields(count));
        }
        if (count > 8) {
            throw new DecodeException("To many entries in Begin list encoding: " + count);
        }
        block10: for (int index = 0; index < count; ++index) {
            boolean nullValue;
            boolean bl = nullValue = buffer.getByte(buffer.getReadIndex()) == 64;
            if (nullValue) {
                if (index > 0 && index < 4) {
                    throw new DecodeException(this.errorForMissingRequiredFields(index));
                }
                buffer.skipBytes(1);
                continue;
            }
            switch (index) {
                case 0: {
                    begin.setRemoteChannel(decoder.readUnsignedShort(buffer, state, 0));
                    continue block10;
                }
                case 1: {
                    begin.setNextOutgoingId(decoder.readUnsignedInteger(buffer, state, 0L));
                    continue block10;
                }
                case 2: {
                    begin.setIncomingWindow(decoder.readUnsignedInteger(buffer, state, 0L));
                    continue block10;
                }
                case 3: {
                    begin.setOutgoingWindow(decoder.readUnsignedInteger(buffer, state, 0L));
                    continue block10;
                }
                case 4: {
                    begin.setHandleMax(decoder.readUnsignedInteger(buffer, state, 0L));
                    continue block10;
                }
                case 5: {
                    begin.setOfferedCapabilities(decoder.readMultiple(buffer, state, Symbol.class));
                    continue block10;
                }
                case 6: {
                    begin.setDesiredCapabilities(decoder.readMultiple(buffer, state, Symbol.class));
                    continue block10;
                }
                case 7: {
                    begin.setProperties(decoder.readMap(buffer, state));
                }
            }
        }
        return begin;
    }

    @Override
    public Begin readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        return this.readBegin(stream, state.getDecoder(), state, (ListTypeDecoder)BeginTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Begin[] readArrayElements(InputStream stream, StreamDecoderState state, int count) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        Begin[] result = new Begin[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readBegin(stream, state.getDecoder(), state, (ListTypeDecoder)BeginTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    @Override
    public void skipValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        BeginTypeDecoder.checkIsExpectedType(ListTypeDecoder.class, decoder);
        decoder.skipValue(stream, state);
    }

    private Begin readBegin(InputStream stream, StreamDecoder decoder, StreamDecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Begin begin = new Begin();
        int size = listDecoder.readSize(stream);
        int count = listDecoder.readCount(stream);
        if (count < 4) {
            throw new DecodeException(this.errorForMissingRequiredFields(count));
        }
        if (count > 8) {
            throw new DecodeException("To many entries in Begin list encoding: " + count);
        }
        block10: for (int index = 0; index < count; ++index) {
            if (stream.markSupported()) {
                boolean nullValue;
                stream.mark(1);
                boolean bl = nullValue = ProtonStreamUtils.readByte(stream) == 64;
                if (nullValue) {
                    if (index <= 0 || index >= 4) continue;
                    throw new DecodeException(this.errorForMissingRequiredFields(index));
                }
                ProtonStreamUtils.reset(stream);
            }
            switch (index) {
                case 0: {
                    begin.setRemoteChannel(decoder.readUnsignedShort(stream, state, 0));
                    continue block10;
                }
                case 1: {
                    begin.setNextOutgoingId(decoder.readUnsignedInteger(stream, state, 0L));
                    continue block10;
                }
                case 2: {
                    begin.setIncomingWindow(decoder.readUnsignedInteger(stream, state, 0L));
                    continue block10;
                }
                case 3: {
                    begin.setOutgoingWindow(decoder.readUnsignedInteger(stream, state, 0L));
                    continue block10;
                }
                case 4: {
                    begin.setHandleMax(decoder.readUnsignedInteger(stream, state, 0L));
                    continue block10;
                }
                case 5: {
                    begin.setOfferedCapabilities(decoder.readMultiple(stream, state, Symbol.class));
                    continue block10;
                }
                case 6: {
                    begin.setDesiredCapabilities(decoder.readMultiple(stream, state, Symbol.class));
                    continue block10;
                }
                case 7: {
                    begin.setProperties(decoder.readMap(stream, state));
                }
            }
        }
        return begin;
    }

    private String errorForMissingRequiredFields(int present) {
        switch (present) {
            case 3: {
                return "The outgoing-window field cannot be omitted from the Begin";
            }
            case 2: {
                return "The incoming-window field cannot be omitted from the Begin";
            }
        }
        return "The next-outgoing-id field cannot be omitted from the Begin";
    }
}

