/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.decoders.primitives;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.DecodeException;
import org.apache.qpid.protonj2.codec.Decoder;
import org.apache.qpid.protonj2.codec.DecoderState;
import org.apache.qpid.protonj2.codec.StreamDecoder;
import org.apache.qpid.protonj2.codec.StreamDecoderState;
import org.apache.qpid.protonj2.codec.decoders.AbstractPrimitiveTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.MapTypeDecoder;

public abstract class AbstractMapTypeDecoder
extends AbstractPrimitiveTypeDecoder<Map>
implements MapTypeDecoder {
    @Override
    public Map<Object, Object> readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        int size = this.readSize(buffer);
        if (size > buffer.getReadableBytes()) {
            throw new DecodeException(String.format("Map encoded size %d is specified to be greater than the amount of data available (%d)", size, buffer.getReadableBytes()));
        }
        int count = this.readCount(buffer);
        if (count % 2 != 0) {
            throw new DecodeException(String.format("Map encoded number of elements %d is not an even number.", count));
        }
        Decoder decoder = state.getDecoder();
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(count);
        for (int i = 0; i < count / 2; ++i) {
            Object key = decoder.readObject(buffer, state);
            Object value = decoder.readObject(buffer, state);
            map.put(key, value);
        }
        return map;
    }

    @Override
    public void skipValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        buffer.skipBytes(this.readSize(buffer));
    }

    @Override
    public Map<Object, Object> readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        this.readSize(stream);
        int count = this.readCount(stream);
        if (count % 2 != 0) {
            throw new DecodeException(String.format("Map encoded number of elements %d is not an even number.", count));
        }
        StreamDecoder decoder = state.getDecoder();
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(count);
        for (int i = 0; i < count / 2; ++i) {
            Object key = decoder.readObject(stream, state);
            Object value = decoder.readObject(stream, state);
            map.put(key, value);
        }
        return map;
    }

    @Override
    public void skipValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        try {
            stream.skip(this.readSize(stream));
        }
        catch (IOException ex) {
            throw new DecodeException("Error while reading Map payload bytes", ex);
        }
    }
}

