/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.decoders.messaging;

import java.io.InputStream;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.DecodeEOFException;
import org.apache.qpid.protonj2.codec.DecodeException;
import org.apache.qpid.protonj2.codec.DecoderState;
import org.apache.qpid.protonj2.codec.StreamDecoderState;
import org.apache.qpid.protonj2.codec.StreamTypeDecoder;
import org.apache.qpid.protonj2.codec.TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.AbstractDescribedTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.List32TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.List8TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.primitives.ListTypeDecoder;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.messaging.Released;

public final class ReleasedTypeDecoder
extends AbstractDescribedTypeDecoder<Released> {
    private static final ListTypeDecoder SMALL_LIST_TYPE_DECODER = new List8TypeDecoder();
    private static final ListTypeDecoder LARGE_LIST_TYPE_DECODER = new List32TypeDecoder();

    @Override
    public Class<Released> getTypeClass() {
        return Released.class;
    }

    @Override
    public UnsignedLong getDescriptorCode() {
        return Released.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Released.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Released readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        byte encodingCode;
        try {
            encodingCode = buffer.readByte();
        }
        catch (IndexOutOfBoundsException e) {
            throw new DecodeEOFException(e);
        }
        switch (encodingCode) {
            case 69: {
                break;
            }
            case -64: {
                SMALL_LIST_TYPE_DECODER.skipValue(buffer, state);
                break;
            }
            case -48: {
                LARGE_LIST_TYPE_DECODER.skipValue(buffer, state);
                break;
            }
            default: {
                throw new DecodeException("Expected list encoding but got decoder for type code: " + encodingCode);
            }
        }
        return Released.getInstance();
    }

    public Released[] readArrayElements(ProtonBuffer buffer, DecoderState state, int count) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        ReleasedTypeDecoder.checkIsExpectedType(ListTypeDecoder.class, decoder);
        Released[] result = new Released[count];
        for (int i = 0; i < count; ++i) {
            decoder.skipValue(buffer, state);
            result[i] = Released.getInstance();
        }
        return result;
    }

    @Override
    public void skipValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        ReleasedTypeDecoder.checkIsExpectedType(ListTypeDecoder.class, decoder);
        decoder.skipValue(buffer, state);
    }

    @Override
    public Released readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        ReleasedTypeDecoder.checkIsExpectedType(ListTypeDecoder.class, decoder);
        decoder.skipValue(stream, state);
        return Released.getInstance();
    }

    public Released[] readArrayElements(InputStream stream, StreamDecoderState state, int count) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        ReleasedTypeDecoder.checkIsExpectedType(ListTypeDecoder.class, decoder);
        Released[] result = new Released[count];
        for (int i = 0; i < count; ++i) {
            decoder.skipValue(stream, state);
            result[i] = Released.getInstance();
        }
        return result;
    }

    @Override
    public void skipValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        ReleasedTypeDecoder.checkIsExpectedType(ListTypeDecoder.class, decoder);
        decoder.skipValue(stream, state);
    }
}

