/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.buffer;

import java.nio.ByteBuffer;
import org.apache.qpid.protonj2.buffer.ProtonAbstractBuffer;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.buffer.ProtonByteUtils;

public class ProtonByteBuffer
extends ProtonAbstractBuffer {
    public static final int DEFAULT_CAPACITY = 64;
    public static final int DEFAULT_MAXIMUM_CAPACITY = Integer.MAX_VALUE;
    private byte[] array;

    public ProtonByteBuffer() {
        this(64, Integer.MAX_VALUE);
    }

    public ProtonByteBuffer(int initialCapacity) {
        this(initialCapacity, Integer.MAX_VALUE);
    }

    public ProtonByteBuffer(int initialCapacity, int maximumCapacity) {
        super(maximumCapacity);
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Initial capacity cannot be < 0");
        }
        if (initialCapacity > maximumCapacity) {
            throw new IllegalArgumentException("Initial capacity cannot exceed maximum capacity.");
        }
        this.array = new byte[initialCapacity];
    }

    public ProtonByteBuffer(byte[] array) {
        this(array, Integer.MAX_VALUE);
    }

    protected ProtonByteBuffer(byte[] array, int maximumCapacity) {
        this(array, maximumCapacity, array.length);
    }

    protected ProtonByteBuffer(byte[] array, int maximumCapacity, int writeIndex) {
        super(maximumCapacity);
        if (array == null) {
            throw new NullPointerException("Array to wrap cannot be null");
        }
        this.array = array;
        this.setIndex(0, writeIndex);
    }

    @Override
    public int capacity() {
        return this.array.length;
    }

    @Override
    public ProtonBuffer capacity(int newCapacity) {
        this.checkNewCapacity(newCapacity);
        int oldCapacity = this.array.length;
        if (newCapacity > oldCapacity) {
            byte[] newArray = new byte[newCapacity];
            System.arraycopy(this.array, 0, newArray, 0, this.array.length);
            this.array = newArray;
        } else if (newCapacity < oldCapacity) {
            byte[] newArray = new byte[newCapacity];
            int readIndex = this.getReadIndex();
            if (readIndex < newCapacity) {
                int writeIndex = this.getWriteIndex();
                if (writeIndex > newCapacity) {
                    writeIndex = newCapacity;
                    this.setWriteIndex(writeIndex);
                }
                System.arraycopy(this.array, readIndex, newArray, readIndex, writeIndex - readIndex);
            } else {
                this.setIndex(newCapacity, newCapacity);
            }
            this.array = newArray;
        }
        return this;
    }

    @Override
    public ProtonBuffer copy(int index, int length) {
        this.checkIndex(index, length);
        byte[] copyOf = new byte[length];
        System.arraycopy(this.array, index, copyOf, 0, length);
        return new ProtonByteBuffer(copyOf, this.maxCapacity(), length);
    }

    @Override
    public ByteBuffer toByteBuffer(int index, int length) {
        return ByteBuffer.wrap(this.array, index, length).slice();
    }

    @Override
    public boolean hasArray() {
        return true;
    }

    @Override
    public byte[] getArray() {
        return this.array;
    }

    @Override
    public int getArrayOffset() {
        return 0;
    }

    @Override
    public byte getByte(int index) {
        return ProtonByteUtils.readByte(this.array, index);
    }

    @Override
    public short getShort(int index) {
        return ProtonByteUtils.readShort(this.array, index);
    }

    @Override
    public int getInt(int index) {
        return ProtonByteUtils.readInt(this.array, index);
    }

    @Override
    public long getLong(int index) {
        return ProtonByteUtils.readLong(this.array, index);
    }

    @Override
    public ProtonBuffer getBytes(int index, ProtonBuffer destination, int destinationIndex, int length) {
        this.checkDestinationIndex(index, length, destinationIndex, destination.capacity());
        if (destination.hasArray()) {
            System.arraycopy(this.array, index, destination.getArray(), destination.getArrayOffset() + destinationIndex, length);
        } else {
            destination.setBytes(destinationIndex, this.array, index, length);
        }
        return this;
    }

    @Override
    public ProtonBuffer getBytes(int index, byte[] destination, int destinationIndex, int length) {
        this.checkDestinationIndex(index, length, destinationIndex, destination.length);
        System.arraycopy(this.array, index, destination, destinationIndex, length);
        return this;
    }

    @Override
    public ProtonBuffer getBytes(int index, ByteBuffer destination) {
        this.checkIndex(index, destination.remaining());
        destination.put(this.array, index, destination.remaining());
        return this;
    }

    @Override
    public ProtonBuffer setByte(int index, int value) {
        ProtonByteUtils.writeByte((byte)value, this.array, index);
        return this;
    }

    @Override
    public ProtonBuffer setShort(int index, int value) {
        ProtonByteUtils.writeShort((short)value, this.array, index);
        return this;
    }

    @Override
    public ProtonBuffer setInt(int index, int value) {
        ProtonByteUtils.writeInt(value, this.array, index);
        return this;
    }

    @Override
    public ProtonBuffer setLong(int index, long value) {
        ProtonByteUtils.writeLong(value, this.array, index);
        return this;
    }

    @Override
    public ProtonBuffer setBytes(int index, ProtonBuffer source, int sourceIndex, int length) {
        this.checkSourceIndex(index, length, sourceIndex, source.capacity());
        if (source.hasArray()) {
            System.arraycopy(source.getArray(), source.getArrayOffset() + sourceIndex, this.array, index, length);
        } else {
            source.getBytes(sourceIndex, this.array, index, length);
        }
        return this;
    }

    @Override
    public ProtonBuffer setBytes(int index, byte[] source, int sourceIndex, int length) {
        this.checkSourceIndex(index, length, sourceIndex, source.length);
        System.arraycopy(source, sourceIndex, this.array, index, length);
        return this;
    }

    @Override
    public ProtonBuffer setBytes(int index, ByteBuffer src) {
        src.get(this.array, index, src.remaining());
        return this;
    }
}

