/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.engine.impl;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.buffer.ProtonByteBufferAllocator;
import org.apache.qpid.protonj2.codec.CodecFactory;
import org.apache.qpid.protonj2.codec.EncodeException;
import org.apache.qpid.protonj2.codec.Encoder;
import org.apache.qpid.protonj2.codec.EncoderState;
import org.apache.qpid.protonj2.engine.EngineHandler;
import org.apache.qpid.protonj2.engine.EngineHandlerContext;
import org.apache.qpid.protonj2.engine.HeaderEnvelope;
import org.apache.qpid.protonj2.engine.OutgoingAMQPEnvelope;
import org.apache.qpid.protonj2.engine.SASLEnvelope;
import org.apache.qpid.protonj2.engine.exceptions.FrameEncodingException;
import org.apache.qpid.protonj2.engine.impl.ProtonEngine;
import org.apache.qpid.protonj2.engine.impl.ProtonEngineConfiguration;
import org.apache.qpid.protonj2.engine.impl.ProtonEngineHandlerContext;
import org.apache.qpid.protonj2.types.transport.AMQPHeader;
import org.apache.qpid.protonj2.types.transport.Performative;

public class ProtonFrameEncodingHandler
implements EngineHandler {
    public static final byte AMQP_FRAME_TYPE = 0;
    public static final byte SASL_FRAME_TYPE = 1;
    private static final int AMQP_PERFORMATIVE_PAD = 256;
    private static final int FRAME_HEADER_SIZE = 8;
    private static final int FRAME_DOFF_SIZE = 2;
    private static final int FRAME_START_BYTE = 0;
    private static final int FRAME_DOFF_BYTE = 4;
    private static final int FRAME_TYPE_BYTE = 5;
    private static final int FRAME_CHANNEL_BYTE = 6;
    private static final byte[] SASL_FRAME_HEADER = new byte[]{0, 0, 0, 0, 2, 1, 0, 0};
    private static final ProtonBuffer EMPTY_BUFFER = ProtonByteBufferAllocator.DEFAULT.wrap(new byte[0]);
    private final Encoder saslEncoder = CodecFactory.getSaslEncoder();
    private final EncoderState saslEncoderState = this.saslEncoder.newEncoderState();
    private final Encoder amqpEncoder = CodecFactory.getEncoder();
    private final EncoderState amqpEncoderState = this.amqpEncoder.newEncoderState();
    private ProtonEngine engine;
    private ProtonEngineConfiguration configuration;

    @Override
    public void handlerAdded(EngineHandlerContext context) {
        this.engine = (ProtonEngine)context.engine();
        this.configuration = this.engine.configuration();
        ((ProtonEngineHandlerContext)context).interestMask(4);
    }

    @Override
    public void handleWrite(EngineHandlerContext context, HeaderEnvelope envelope) {
        context.fireWrite(((AMQPHeader)envelope.getBody()).getBuffer(), null);
    }

    @Override
    public void handleWrite(EngineHandlerContext context, SASLEnvelope envelope) {
        ProtonBuffer output = this.configuration.getBufferAllocator().outputBuffer(256, (int)this.configuration.getOutboundMaxFrameSize());
        output.setWriteIndex(8);
        output.setBytes(0, SASL_FRAME_HEADER);
        try {
            this.saslEncoder.writeObject(output, this.saslEncoderState, envelope.getBody());
        }
        catch (EncodeException ex) {
            throw new FrameEncodingException(ex);
        }
        finally {
            this.saslEncoderState.reset();
        }
        context.fireWrite(output.setInt(0, output.getReadableBytes()), null);
    }

    @Override
    public void handleWrite(EngineHandlerContext context, OutgoingAMQPEnvelope envelope) {
        ProtonBuffer payload = envelope.getPayload() == null ? EMPTY_BUFFER : envelope.getPayload();
        int maxFrameSize = (int)this.configuration.getOutboundMaxFrameSize();
        int outputBufferSize = Math.min(maxFrameSize, 256 + payload.getReadableBytes());
        ProtonBuffer output = this.configuration.getBufferAllocator().outputBuffer(outputBufferSize, maxFrameSize);
        ProtonFrameEncodingHandler.writePerformative(output, this.amqpEncoder, this.amqpEncoderState, (Performative)envelope.getBody());
        if (payload.getReadableBytes() > output.getMaxWritableBytes()) {
            envelope.handlePayloadToLarge();
            ProtonFrameEncodingHandler.writePerformative(output, this.amqpEncoder, this.amqpEncoderState, (Performative)envelope.getBody());
            output.writeBytes(payload, output.getMaxWritableBytes());
        } else {
            output.writeBytes(payload);
        }
        output.setInt(0, output.getReadableBytes());
        output.setByte(4, 2);
        output.setByte(5, 0);
        output.setShort(6, (short)envelope.getChannel());
        context.fireWrite(output, envelope::handleOutgoingFrameWriteComplete);
    }

    private static void writePerformative(ProtonBuffer target, Encoder encoder, EncoderState state, Performative performative) {
        target.setWriteIndex(8);
        try {
            encoder.writeObject(target, state, performative);
        }
        catch (EncodeException ex) {
            throw new FrameEncodingException(ex);
        }
        finally {
            state.reset();
        }
    }
}

