/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.engine.impl;

import org.apache.qpid.protonj2.buffer.ProtonBufferAllocator;
import org.apache.qpid.protonj2.buffer.ProtonByteBufferAllocator;
import org.apache.qpid.protonj2.engine.EngineConfiguration;
import org.apache.qpid.protonj2.engine.EngineHandler;
import org.apache.qpid.protonj2.engine.EngineSaslDriver;
import org.apache.qpid.protonj2.engine.impl.ProtonEngine;
import org.apache.qpid.protonj2.engine.impl.ProtonFrameLoggingHandler;
import org.apache.qpid.protonj2.logging.ProtonLogger;
import org.apache.qpid.protonj2.logging.ProtonLoggerFactory;
import org.apache.qpid.protonj2.types.UnsignedInteger;

public class ProtonEngineConfiguration
implements EngineConfiguration {
    private static final ProtonLogger LOG = ProtonLoggerFactory.getLogger(ProtonEngineConfiguration.class);
    private final ProtonEngine engine;
    private ProtonBufferAllocator allocator = ProtonByteBufferAllocator.DEFAULT;
    private long effectiveMaxInboundFrameSize = 512L;
    private long effectiveMaxOutboundFrameSize = 512L;

    ProtonEngineConfiguration(ProtonEngine engine) {
        this.engine = engine;
    }

    @Override
    public ProtonBufferAllocator getBufferAllocator() {
        return this.allocator;
    }

    @Override
    public ProtonEngineConfiguration setBufferAllocator(ProtonBufferAllocator allocator) {
        this.allocator = allocator;
        return this;
    }

    @Override
    public EngineConfiguration setTraceFrames(boolean traceFrames) {
        EngineHandler handler = this.engine.pipeline().find("frame-logger");
        if (handler != null && handler instanceof ProtonFrameLoggingHandler) {
            ((ProtonFrameLoggingHandler)handler).setTraceFrames(traceFrames);
        } else {
            LOG.debug("Engine not configured with a frame logging handler: cannot apply traceFrames={}", (Object)traceFrames);
        }
        return this;
    }

    @Override
    public boolean isTraceFrames() {
        EngineHandler handler = this.engine.pipeline().find("frame-logger");
        if (handler != null && handler instanceof ProtonFrameLoggingHandler) {
            return ((ProtonFrameLoggingHandler)handler).isTraceFrames();
        }
        return false;
    }

    void recomputeEffectiveFrameSizeLimits() {
        if (this.engine.saslDriver().getSaslState().ordinal() < EngineSaslDriver.SaslState.AUTHENTICATED.ordinal()) {
            this.effectiveMaxInboundFrameSize = this.engine.saslDriver().getMaxFrameSize();
            this.effectiveMaxOutboundFrameSize = this.engine.saslDriver().getMaxFrameSize();
        } else {
            long localMaxFrameSize = this.engine.connection().getMaxFrameSize();
            long remoteMaxFrameSize = this.engine.connection().getRemoteMaxFrameSize();
            long intermediateMaxOutboundFrameSize = Math.min(localMaxFrameSize, remoteMaxFrameSize);
            this.effectiveMaxInboundFrameSize = Math.min(UnsignedInteger.MAX_VALUE.longValue(), this.engine.connection().getMaxFrameSize());
            this.effectiveMaxOutboundFrameSize = Math.min(UnsignedInteger.MAX_VALUE.longValue(), intermediateMaxOutboundFrameSize);
        }
    }

    long getOutboundMaxFrameSize() {
        return this.effectiveMaxOutboundFrameSize;
    }

    long getInboundMaxFrameSize() {
        return this.effectiveMaxInboundFrameSize;
    }
}

