/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.codec.decoders.messaging;

import java.io.InputStream;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.codec.DecodeException;
import org.apache.qpid.protonj2.codec.DecoderState;
import org.apache.qpid.protonj2.codec.StreamDecoderState;
import org.apache.qpid.protonj2.codec.StreamTypeDecoder;
import org.apache.qpid.protonj2.codec.TypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.AbstractDescribedTypeDecoder;
import org.apache.qpid.protonj2.codec.decoders.ProtonStreamUtils;
import org.apache.qpid.protonj2.codec.decoders.primitives.ListTypeDecoder;
import org.apache.qpid.protonj2.types.Symbol;
import org.apache.qpid.protonj2.types.UnsignedLong;
import org.apache.qpid.protonj2.types.messaging.Header;

public final class HeaderTypeDecoder
extends AbstractDescribedTypeDecoder<Header> {
    private static final int MIN_HEADER_LIST_ENTRIES = 0;
    private static final int MAX_HEADER_LIST_ENTRIES = 5;

    @Override
    public Class<Header> getTypeClass() {
        return Header.class;
    }

    @Override
    public UnsignedLong getDescriptorCode() {
        return Header.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Header.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Header readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        return this.readHeader(buffer, state, (ListTypeDecoder)HeaderTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Header[] readArrayElements(ProtonBuffer buffer, DecoderState state, int count) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        ListTypeDecoder listDecoder = (ListTypeDecoder)HeaderTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder);
        Header[] result = new Header[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readHeader(buffer, state, listDecoder);
        }
        return result;
    }

    @Override
    public void skipValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        HeaderTypeDecoder.checkIsExpectedType(ListTypeDecoder.class, decoder);
        decoder.skipValue(buffer, state);
    }

    private Header readHeader(ProtonBuffer buffer, DecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Header header = new Header();
        int size = listDecoder.readSize(buffer);
        int count = listDecoder.readCount(buffer);
        if (count < 0) {
            throw new DecodeException("Not enough entries in Header list encoding: " + count);
        }
        if (count > 5) {
            throw new DecodeException("To many entries in Header list encoding: " + count);
        }
        block7: for (int index = 0; index < count; ++index) {
            boolean nullValue;
            boolean bl = nullValue = buffer.getByte(buffer.getReadIndex()) == 64;
            if (nullValue) {
                buffer.readByte();
                continue;
            }
            switch (index) {
                case 0: {
                    header.setDurable(state.getDecoder().readBoolean(buffer, state, false));
                    continue block7;
                }
                case 1: {
                    header.setPriority(state.getDecoder().readUnsignedByte(buffer, state, (byte)4));
                    continue block7;
                }
                case 2: {
                    header.setTimeToLive(state.getDecoder().readUnsignedInteger(buffer, state, 0L));
                    continue block7;
                }
                case 3: {
                    header.setFirstAcquirer(state.getDecoder().readBoolean(buffer, state, false));
                    continue block7;
                }
                case 4: {
                    header.setDeliveryCount(state.getDecoder().readUnsignedInteger(buffer, state, 0L));
                }
            }
        }
        return header;
    }

    @Override
    public Header readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        return this.readHeader(stream, state, (ListTypeDecoder)HeaderTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Header[] readArrayElements(InputStream stream, StreamDecoderState state, int count) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        ListTypeDecoder listDecoder = (ListTypeDecoder)HeaderTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder);
        Header[] result = new Header[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readHeader(stream, state, listDecoder);
        }
        return result;
    }

    @Override
    public void skipValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        HeaderTypeDecoder.checkIsExpectedType(ListTypeDecoder.class, decoder);
        decoder.skipValue(stream, state);
    }

    private Header readHeader(InputStream stream, StreamDecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Header header = new Header();
        int size = listDecoder.readSize(stream);
        int count = listDecoder.readCount(stream);
        if (count < 0) {
            throw new DecodeException("Not enough entries in Header list encoding: " + count);
        }
        if (count > 5) {
            throw new DecodeException("To many entries in Header list encoding: " + count);
        }
        block7: for (int index = 0; index < count; ++index) {
            if (stream.markSupported()) {
                stream.mark(1);
                if (ProtonStreamUtils.readByte(stream) == 64) continue;
                ProtonStreamUtils.reset(stream);
            }
            switch (index) {
                case 0: {
                    header.setDurable(state.getDecoder().readBoolean(stream, state, false));
                    continue block7;
                }
                case 1: {
                    header.setPriority(state.getDecoder().readUnsignedByte(stream, state, (byte)4));
                    continue block7;
                }
                case 2: {
                    header.setTimeToLive(state.getDecoder().readUnsignedInteger(stream, state, 0L));
                    continue block7;
                }
                case 3: {
                    header.setFirstAcquirer(state.getDecoder().readBoolean(stream, state, false));
                    continue block7;
                }
                case 4: {
                    header.setDeliveryCount(state.getDecoder().readUnsignedInteger(stream, state, 0L));
                }
            }
        }
        return header;
    }
}

