/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.buffer;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.qpid.protonj2.buffer.ProtonAbstractBuffer;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;

public class ProtonDuplicatedBuffer
extends ProtonAbstractBuffer {
    private final ProtonAbstractBuffer buffer;

    public ProtonDuplicatedBuffer(ProtonAbstractBuffer buffer) {
        super(buffer.maxCapacity());
        Objects.requireNonNull(buffer, "The buffer being wrapped by a duplicate must not be null");
        this.buffer = buffer instanceof ProtonDuplicatedBuffer ? ((ProtonDuplicatedBuffer)buffer).buffer : buffer;
        this.setIndex(buffer.getReadIndex(), buffer.getWriteIndex());
        this.markReadIndex();
        this.markWriteIndex();
    }

    @Override
    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    @Override
    public byte[] getArray() {
        return this.buffer.getArray();
    }

    @Override
    public int getArrayOffset() {
        return this.buffer.getArrayOffset();
    }

    @Override
    public int capacity() {
        return this.buffer.capacity();
    }

    @Override
    public ProtonBuffer capacity(int newCapacity) {
        this.buffer.capacity(newCapacity);
        if (this.getReadIndex() < newCapacity) {
            if (this.getWriteIndex() > newCapacity) {
                this.setWriteIndex(newCapacity);
            }
        } else {
            this.setIndex(newCapacity, newCapacity);
        }
        return this;
    }

    @Override
    public ProtonBuffer duplicate() {
        return new ProtonDuplicatedBuffer(this);
    }

    @Override
    public ProtonBuffer slice(int index, int length) {
        return this.buffer.slice(index, length);
    }

    @Override
    public byte getByte(int index) {
        return this.buffer.getByte(index);
    }

    @Override
    public short getShort(int index) {
        return this.buffer.getShort(index);
    }

    @Override
    public int getInt(int index) {
        return this.buffer.getInt(index);
    }

    @Override
    public long getLong(int index) {
        return this.buffer.getLong(index);
    }

    @Override
    public ProtonBuffer getBytes(int index, ProtonBuffer destination, int destinationIndex, int length) {
        this.buffer.getBytes(index, destination, destinationIndex, length);
        return this;
    }

    @Override
    public ProtonBuffer getBytes(int index, byte[] destination, int offset, int length) {
        this.buffer.getBytes(index, destination, offset, length);
        return this;
    }

    @Override
    public ProtonBuffer getBytes(int index, ByteBuffer destination) {
        this.buffer.getBytes(index, destination);
        return this;
    }

    @Override
    public ProtonBuffer setByte(int index, int value) {
        this.buffer.setByte(index, value);
        return this;
    }

    @Override
    public ProtonBuffer setShort(int index, int value) {
        this.buffer.setShort(index, value);
        return this;
    }

    @Override
    public ProtonBuffer setInt(int index, int value) {
        this.buffer.setInt(index, value);
        return this;
    }

    @Override
    public ProtonBuffer setLong(int index, long value) {
        this.buffer.setLong(index, value);
        return this;
    }

    @Override
    public ProtonBuffer setBytes(int index, ProtonBuffer source, int sourceIndex, int length) {
        this.buffer.setBytes(index, source, sourceIndex, length);
        return this;
    }

    @Override
    public ProtonBuffer setBytes(int index, byte[] source, int sourceIndex, int length) {
        this.buffer.setBytes(index, source, sourceIndex, length);
        return this;
    }

    @Override
    public ProtonBuffer setBytes(int index, ByteBuffer source) {
        this.buffer.setBytes(index, source);
        return this;
    }

    @Override
    public ProtonBuffer copy(int index, int length) {
        return this.buffer.copy(index, length);
    }

    @Override
    public ByteBuffer toByteBuffer(int index, int length) {
        return this.buffer.toByteBuffer(index, length);
    }
}

