/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.client.impl;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.Principal;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;
import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.client.Connection;
import org.apache.qpid.protonj2.client.ConnectionEvent;
import org.apache.qpid.protonj2.client.ConnectionOptions;
import org.apache.qpid.protonj2.client.DisconnectionEvent;
import org.apache.qpid.protonj2.client.ErrorCondition;
import org.apache.qpid.protonj2.client.Message;
import org.apache.qpid.protonj2.client.NextReceiverPolicy;
import org.apache.qpid.protonj2.client.Receiver;
import org.apache.qpid.protonj2.client.ReceiverOptions;
import org.apache.qpid.protonj2.client.ReconnectLocation;
import org.apache.qpid.protonj2.client.Sender;
import org.apache.qpid.protonj2.client.SenderOptions;
import org.apache.qpid.protonj2.client.Session;
import org.apache.qpid.protonj2.client.SessionOptions;
import org.apache.qpid.protonj2.client.StreamReceiver;
import org.apache.qpid.protonj2.client.StreamReceiverOptions;
import org.apache.qpid.protonj2.client.StreamSender;
import org.apache.qpid.protonj2.client.StreamSenderOptions;
import org.apache.qpid.protonj2.client.Tracker;
import org.apache.qpid.protonj2.client.exceptions.ClientConnectionRemotelyClosedException;
import org.apache.qpid.protonj2.client.exceptions.ClientConnectionSecurityException;
import org.apache.qpid.protonj2.client.exceptions.ClientConnectionSecuritySaslException;
import org.apache.qpid.protonj2.client.exceptions.ClientException;
import org.apache.qpid.protonj2.client.exceptions.ClientIOException;
import org.apache.qpid.protonj2.client.exceptions.ClientIllegalStateException;
import org.apache.qpid.protonj2.client.exceptions.ClientOperationTimedOutException;
import org.apache.qpid.protonj2.client.exceptions.ClientUnsupportedOperationException;
import org.apache.qpid.protonj2.client.futures.ClientFuture;
import org.apache.qpid.protonj2.client.futures.ClientFutureFactory;
import org.apache.qpid.protonj2.client.impl.ClientConnectionCapabilities;
import org.apache.qpid.protonj2.client.impl.ClientConversionSupport;
import org.apache.qpid.protonj2.client.impl.ClientErrorCondition;
import org.apache.qpid.protonj2.client.impl.ClientExceptionSupport;
import org.apache.qpid.protonj2.client.impl.ClientInstance;
import org.apache.qpid.protonj2.client.impl.ClientSender;
import org.apache.qpid.protonj2.client.impl.ClientSession;
import org.apache.qpid.protonj2.client.impl.ClientSessionBuilder;
import org.apache.qpid.protonj2.client.impl.ClientStreamSession;
import org.apache.qpid.protonj2.client.impl.ClientTransportListener;
import org.apache.qpid.protonj2.client.transport.NettyIOContext;
import org.apache.qpid.protonj2.client.transport.Transport;
import org.apache.qpid.protonj2.client.util.ReconnectLocationPool;
import org.apache.qpid.protonj2.client.util.TrackableThreadFactory;
import org.apache.qpid.protonj2.engine.Engine;
import org.apache.qpid.protonj2.engine.EngineFactory;
import org.apache.qpid.protonj2.engine.sasl.SaslClientListener;
import org.apache.qpid.protonj2.engine.sasl.client.SaslAuthenticator;
import org.apache.qpid.protonj2.engine.sasl.client.SaslCredentialsProvider;
import org.apache.qpid.protonj2.engine.sasl.client.SaslMechanismSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientConnection
implements Connection {
    private static final Logger LOG = LoggerFactory.getLogger(ClientConnection.class);
    private static final int UNLIMITED = -1;
    private static final int UNDEFINED = -1;
    private static final AtomicIntegerFieldUpdater<ClientConnection> CLOSED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ClientConnection.class, "closed");
    private static final AtomicReferenceFieldUpdater<ClientConnection, ClientIOException> FAILURE_CAUSE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ClientConnection.class, ClientIOException.class, "failureCause");
    private final ClientInstance client;
    private final ConnectionOptions options;
    private final ClientConnectionCapabilities capabilities = new ClientConnectionCapabilities();
    private final ClientFutureFactory futureFactory;
    private final ClientSessionBuilder sessionBuilder;
    private final ReconnectLocationPool reconnectPool = new ReconnectLocationPool();
    private final NettyIOContext ioContext;
    private final String connectionId;
    private final ScheduledExecutorService executor;
    private final ThreadPoolExecutor notifications;
    private Engine engine;
    private org.apache.qpid.protonj2.engine.Connection protonConnection;
    private ClientSession connectionSession;
    private ClientSender connectionSender;
    private Transport transport;
    private boolean autoFlush = true;
    private ClientFuture<Connection> openFuture;
    private ClientFuture<Connection> closeFuture;
    private volatile int closed;
    private volatile ClientIOException failureCause;
    private long totalConnections;
    private long reconnectAttempts;
    private long nextReconnectDelay = -1L;

    ClientConnection(ClientInstance client, String host, int port, ConnectionOptions options) {
        this.client = client;
        this.options = options;
        this.connectionId = client.nextConnectionId();
        this.futureFactory = ClientFutureFactory.create(client.options().futureType());
        this.openFuture = this.futureFactory.createFuture();
        this.closeFuture = this.futureFactory.createFuture();
        this.sessionBuilder = new ClientSessionBuilder(this);
        this.ioContext = new NettyIOContext(options.transportOptions(), options.sslOptions(), "ClientConnection :(" + this.connectionId + "): I/O Thread");
        this.executor = this.ioContext.eventLoop();
        this.notifications = new ThreadPoolExecutor(1, 1, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), new TrackableThreadFactory("protonj2 Client Connection Executor: " + this.getId(), true));
        this.notifications.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardOldestPolicy());
        this.reconnectPool.add(new ReconnectLocation(host, port));
        this.reconnectPool.addAll(options.reconnectOptions().reconnectLocations());
    }

    @Override
    public ClientInstance client() {
        return this.client;
    }

    @Override
    public Future<Connection> openFuture() {
        return this.openFuture;
    }

    @Override
    public void close() {
        try {
            this.doClose(null).get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.interrupted();
        }
    }

    @Override
    public void close(ErrorCondition error) {
        try {
            this.doClose(error).get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.interrupted();
        }
    }

    @Override
    public Future<Connection> closeAsync() {
        return this.doClose(null);
    }

    @Override
    public Future<Connection> closeAsync(ErrorCondition error) {
        Objects.requireNonNull(error, "Error supplied cannot be null");
        return this.doClose(error);
    }

    private Future<Connection> doClose(ErrorCondition error) {
        if (CLOSED_UPDATER.compareAndSet(this, 0, 1)) {
            try {
                if (!this.closeFuture.isDone()) {
                    this.executor.execute(() -> {
                        LOG.trace("Close requested for connection: {}", (Object)this);
                        if (this.protonConnection.isLocallyOpen()) {
                            this.protonConnection.setCondition(ClientErrorCondition.asProtonErrorCondition(error));
                            try {
                                this.protonConnection.close();
                            }
                            catch (Throwable throwable) {}
                        } else {
                            this.engine.shutdown();
                        }
                    });
                }
            }
            catch (RejectedExecutionException rje) {
                LOG.trace("Close task rejected from the event loop", (Throwable)rje);
            }
        }
        return this.closeFuture;
    }

    @Override
    public Session defaultSession() throws ClientException {
        this.checkClosedOrFailed();
        ClientFuture defaultSession = this.getFutureFactory().createFuture();
        this.executor.execute(() -> {
            try {
                this.checkClosedOrFailed();
                defaultSession.complete(this.lazyCreateConnectionSession());
            }
            catch (Throwable error) {
                defaultSession.failed(ClientExceptionSupport.createNonFatalOrPassthrough(error));
            }
        });
        return (Session)this.request(this, defaultSession);
    }

    @Override
    public Session openSession() throws ClientException {
        return this.openSession(null);
    }

    @Override
    public Session openSession(SessionOptions sessionOptions) throws ClientException {
        this.checkClosedOrFailed();
        ClientFuture createSession = this.getFutureFactory().createFuture();
        this.executor.execute(() -> {
            try {
                this.checkClosedOrFailed();
                createSession.complete(this.sessionBuilder.session(sessionOptions).open());
            }
            catch (Throwable error) {
                createSession.failed(ClientExceptionSupport.createNonFatalOrPassthrough(error));
            }
        });
        return (Session)this.request(this, createSession);
    }

    @Override
    public Receiver openReceiver(String address) throws ClientException {
        return this.openReceiver(address, null);
    }

    @Override
    public Receiver openReceiver(String address, ReceiverOptions receiverOptions) throws ClientException {
        this.checkClosedOrFailed();
        Objects.requireNonNull(address, "Cannot create a receiver with a null address");
        ClientFuture createReceiver = this.getFutureFactory().createFuture();
        this.executor.execute(() -> {
            try {
                this.checkClosedOrFailed();
                createReceiver.complete(this.lazyCreateConnectionSession().internalOpenReceiver(address, receiverOptions));
            }
            catch (Throwable error) {
                createReceiver.failed(ClientExceptionSupport.createNonFatalOrPassthrough(error));
            }
        });
        return (Receiver)this.request(this, createReceiver);
    }

    @Override
    public Receiver openDurableReceiver(String address, String subscriptionName) throws ClientException {
        return this.openDurableReceiver(address, subscriptionName, null);
    }

    @Override
    public Receiver openDurableReceiver(String address, String subscriptionName, ReceiverOptions receiverOptions) throws ClientException {
        this.checkClosedOrFailed();
        Objects.requireNonNull(address, "Cannot create a receiver with a null address");
        ClientFuture createReceiver = this.getFutureFactory().createFuture();
        this.executor.execute(() -> {
            try {
                this.checkClosedOrFailed();
                createReceiver.complete(this.lazyCreateConnectionSession().internalOpenDurableReceiver(address, subscriptionName, receiverOptions));
            }
            catch (Throwable error) {
                createReceiver.failed(ClientExceptionSupport.createNonFatalOrPassthrough(error));
            }
        });
        return (Receiver)this.request(this, createReceiver);
    }

    @Override
    public Receiver openDynamicReceiver() throws ClientException {
        return this.openDynamicReceiver(null, null);
    }

    @Override
    public Receiver openDynamicReceiver(Map<String, Object> dynamicNodeProperties) throws ClientException {
        return this.openDynamicReceiver(dynamicNodeProperties, null);
    }

    @Override
    public Receiver openDynamicReceiver(ReceiverOptions receiverOptions) throws ClientException {
        return this.openDynamicReceiver(null, receiverOptions);
    }

    @Override
    public Receiver openDynamicReceiver(Map<String, Object> dynamicNodeProperties, ReceiverOptions receiverOptions) throws ClientException {
        this.checkClosedOrFailed();
        ClientFuture createReceiver = this.getFutureFactory().createFuture();
        this.executor.execute(() -> {
            try {
                this.checkClosedOrFailed();
                createReceiver.complete(this.lazyCreateConnectionSession().internalOpenDynamicReceiver(dynamicNodeProperties, receiverOptions));
            }
            catch (Throwable error) {
                createReceiver.failed(ClientExceptionSupport.createNonFatalOrPassthrough(error));
            }
        });
        return (Receiver)this.request(this, createReceiver);
    }

    @Override
    public StreamReceiver openStreamReceiver(String address) throws ClientException {
        return this.openStreamReceiver(address, null);
    }

    @Override
    public StreamReceiver openStreamReceiver(String address, StreamReceiverOptions receiverOptions) throws ClientException {
        this.checkClosedOrFailed();
        ClientFuture createRequest = this.getFutureFactory().createFuture();
        this.executor.execute(() -> {
            try {
                int sessionCapacity = 0x6400000;
                if (receiverOptions != null) {
                    sessionCapacity = receiverOptions.readBufferSize() / 2;
                }
                sessionCapacity = (int)Math.max((long)sessionCapacity, this.protonConnection.getMaxFrameSize());
                this.checkClosedOrFailed();
                SessionOptions sessionOptions = new SessionOptions(this.sessionBuilder.getDefaultSessionOptions());
                ClientStreamSession session = (ClientStreamSession)this.sessionBuilder.streamSession(sessionOptions.incomingCapacity(sessionCapacity)).open();
                createRequest.complete(session.internalOpenStreamReceiver(address, receiverOptions));
            }
            catch (Throwable error) {
                createRequest.failed(ClientExceptionSupport.createNonFatalOrPassthrough(error));
            }
        });
        return (StreamReceiver)this.request(this, createRequest);
    }

    @Override
    public Sender defaultSender() throws ClientException {
        this.checkClosedOrFailed();
        ClientFuture defaultSender = this.getFutureFactory().createFuture();
        this.executor.execute(() -> {
            try {
                this.checkClosedOrFailed();
                defaultSender.complete(this.lazyCreateConnectionSender());
            }
            catch (Throwable error) {
                defaultSender.failed(ClientExceptionSupport.createNonFatalOrPassthrough(error));
            }
        });
        return (Sender)this.request(this, defaultSender);
    }

    @Override
    public Sender openSender(String address) throws ClientException {
        return this.openSender(address, null);
    }

    @Override
    public Sender openSender(String address, SenderOptions senderOptions) throws ClientException {
        this.checkClosedOrFailed();
        Objects.requireNonNull(address, "Cannot create a sender with a null address");
        ClientFuture createSender = this.getFutureFactory().createFuture();
        this.executor.execute(() -> {
            try {
                this.checkClosedOrFailed();
                createSender.complete(this.lazyCreateConnectionSession().internalOpenSender(address, senderOptions));
            }
            catch (Throwable error) {
                createSender.failed(ClientExceptionSupport.createNonFatalOrPassthrough(error));
            }
        });
        return (Sender)this.request(this, createSender);
    }

    @Override
    public Sender openAnonymousSender() throws ClientException {
        return this.openAnonymousSender(null);
    }

    @Override
    public Sender openAnonymousSender(SenderOptions senderOptions) throws ClientException {
        this.checkClosedOrFailed();
        ClientFuture createRequest = this.getFutureFactory().createFuture();
        this.executor.execute(() -> {
            try {
                this.checkClosedOrFailed();
                createRequest.complete(this.lazyCreateConnectionSession().internalOpenAnonymousSender(senderOptions));
            }
            catch (Throwable error) {
                createRequest.failed(ClientExceptionSupport.createNonFatalOrPassthrough(error));
            }
        });
        return (Sender)this.request(this, createRequest);
    }

    @Override
    public StreamSender openStreamSender(String address) throws ClientException {
        return this.openStreamSender(address, null);
    }

    @Override
    public StreamSender openStreamSender(String address, StreamSenderOptions senderOptions) throws ClientException {
        this.checkClosedOrFailed();
        Objects.requireNonNull(address, "Cannot create a sender with a null address");
        ClientFuture createRequest = this.getFutureFactory().createFuture();
        this.executor.execute(() -> {
            try {
                int sessionCapacity = 0x6400000;
                if (senderOptions != null) {
                    sessionCapacity = senderOptions.pendingWritesBufferSize();
                }
                sessionCapacity = (int)Math.max((long)sessionCapacity, this.protonConnection.getMaxFrameSize());
                this.checkClosedOrFailed();
                SessionOptions sessionOptions = new SessionOptions(this.sessionBuilder.getDefaultSessionOptions());
                ClientStreamSession session = (ClientStreamSession)this.sessionBuilder.streamSession(sessionOptions.outgoingCapacity(sessionCapacity)).open();
                createRequest.complete(session.internalOpenStreamSender(address, senderOptions));
            }
            catch (Throwable error) {
                createRequest.failed(ClientExceptionSupport.createNonFatalOrPassthrough(error));
            }
        });
        return (StreamSender)this.request(this, createRequest);
    }

    @Override
    public Tracker send(Message<?> message) throws ClientException {
        this.checkClosedOrFailed();
        Objects.requireNonNull(message, "Cannot send a null message");
        ClientFuture result = this.getFutureFactory().createFuture();
        this.executor.execute(() -> {
            try {
                this.checkClosedOrFailed();
                result.complete(this.lazyCreateConnectionSender());
            }
            catch (Throwable error) {
                result.failed(ClientExceptionSupport.createNonFatalOrPassthrough(error));
            }
        });
        return ((Sender)this.request(this, result)).send(message);
    }

    @Override
    public Receiver nextReceiver() throws ClientException {
        this.checkClosedOrFailed();
        return this.defaultSession().nextReceiver();
    }

    @Override
    public Receiver nextReceiver(long timeout, TimeUnit unit) throws ClientException {
        this.checkClosedOrFailed();
        return this.defaultSession().nextReceiver(timeout, unit);
    }

    @Override
    public Receiver nextReceiver(NextReceiverPolicy policy) throws ClientException {
        this.checkClosedOrFailed();
        return this.defaultSession().nextReceiver(policy);
    }

    @Override
    public Receiver nextReceiver(NextReceiverPolicy policy, long timeout, TimeUnit unit) throws ClientException {
        this.checkClosedOrFailed();
        return this.defaultSession().nextReceiver(policy, timeout, unit);
    }

    @Override
    public Map<String, Object> properties() throws ClientException {
        this.waitForOpenToComplete();
        return ClientConversionSupport.toStringKeyedMap(this.protonConnection.getRemoteProperties());
    }

    @Override
    public String[] offeredCapabilities() throws ClientException {
        this.waitForOpenToComplete();
        return ClientConversionSupport.toStringArray(this.protonConnection.getRemoteOfferedCapabilities());
    }

    @Override
    public String[] desiredCapabilities() throws ClientException {
        this.waitForOpenToComplete();
        return ClientConversionSupport.toStringArray(this.protonConnection.getRemoteDesiredCapabilities());
    }

    public String toString() {
        return "ClientConnection:[" + this.getId() + "]";
    }

    String getId() {
        return this.connectionId;
    }

    Engine getEngine() {
        return this.engine;
    }

    ClientConnection connect() throws ClientException {
        try {
            ReconnectLocation remoteLocation = this.reconnectPool.getNext();
            this.initializeProtonResources(remoteLocation);
            this.scheduleReconnect(remoteLocation);
            return this;
        }
        catch (Exception ex) {
            CLOSED_UPDATER.set(this, 1);
            FAILURE_CAUSE_UPDATER.compareAndSet(this, null, ClientExceptionSupport.createOrPassthroughFatal(ex));
            this.openFuture.failed(this.failureCause);
            this.closeFuture.complete(this);
            this.ioContext.shutdown();
            throw this.failureCause;
        }
    }

    boolean isClosed() {
        return this.closed > 0;
    }

    ScheduledExecutorService getScheduler() {
        return this.executor;
    }

    ClientFutureFactory getFutureFactory() {
        return this.futureFactory;
    }

    ConnectionOptions getOptions() {
        return this.options;
    }

    ClientConnectionCapabilities getCapabilities() {
        return this.capabilities;
    }

    org.apache.qpid.protonj2.engine.Connection getProtonConnection() {
        return this.protonConnection;
    }

    <T> T request(Object requestor, ClientFuture<T> request) throws ClientException {
        try {
            return request.get();
        }
        catch (Throwable error) {
            request.cancel(false);
            throw ClientExceptionSupport.createNonFatalOrPassthrough(error);
        }
    }

    boolean autoFlushOff() {
        boolean oldState = this.autoFlush;
        this.autoFlush = false;
        return oldState;
    }

    void autoFlushOn() {
        this.autoFlush = true;
    }

    void flush() {
        try {
            this.transport.flush();
        }
        catch (IOException e) {
            LOG.debug("Error while flushing engine output to transport: ", (Object)e.getMessage());
            throw new UncheckedIOException(e);
        }
    }

    private void handleLocalOpen(org.apache.qpid.protonj2.engine.Connection connection) {
        connection.tickAuto(this.getScheduler());
        if (this.options.openTimeout() > 0L) {
            this.executor.schedule(() -> {
                if (!this.openFuture.isDone()) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    connection.getEngine().engineFailed((Throwable)new ClientOperationTimedOutException("Connection Open timed out waiting for remote to open"));
                }
            }, this.options.openTimeout(), TimeUnit.MILLISECONDS);
        }
    }

    private void handleLocalClose(org.apache.qpid.protonj2.engine.Connection connection) {
        if (connection.isRemotelyClosed()) {
            ClientConnectionRemotelyClosedException failureCause = this.engine.connection().getRemoteCondition() != null ? ClientExceptionSupport.convertToConnectionClosedException(connection.getRemoteCondition()) : new ClientConnectionRemotelyClosedException("Unknown error led to connection disconnect");
            try {
                connection.getEngine().engineFailed((Throwable)failureCause);
            }
            catch (Throwable throwable) {}
        } else if (!this.engine.isShutdown() || !this.engine.isFailed()) {
            this.executor.schedule(() -> {
                try {
                    connection.getEngine().shutdown();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }, this.options.closeTimeout(), TimeUnit.MILLISECONDS);
        }
    }

    private void handleRemoteOpen(org.apache.qpid.protonj2.engine.Connection connection) {
        this.connectionEstablished();
        this.capabilities.determineCapabilities(connection);
        if (this.totalConnections == 1L) {
            LOG.info("Connection {} connected to server: {}:{}", new Object[]{this.getId(), this.transport.getHost(), this.transport.getPort()});
            this.submitConnectionEvent(this.options.connectedHandler(), this.transport.getHost(), this.transport.getPort(), null);
        } else {
            LOG.info("Connection {} reconnected to server: {}:{}", new Object[]{this.getId(), this.transport.getHost(), this.transport.getPort()});
            this.submitConnectionEvent(this.options.reconnectedHandler(), this.transport.getHost(), this.transport.getPort(), null);
        }
        this.openFuture.complete(this);
    }

    private void handleRemoteClose(org.apache.qpid.protonj2.engine.Connection connection) {
        if (connection.isLocallyClosed()) {
            try {
                connection.getEngine().shutdown();
            }
            catch (Throwable ignore) {
                LOG.debug("Unexpected exception thrown from engine shutdown: ", ignore);
            }
        } else {
            try {
                connection.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void handleEngineOutput(ProtonBuffer output, Runnable ioComplete) {
        try {
            if (this.autoFlush) {
                this.transport.writeAndFlush(output, ioComplete);
            } else {
                this.transport.write(output, ioComplete);
            }
        }
        catch (IOException e) {
            LOG.debug("Error while writing engine output to transport: ", (Object)e.getMessage());
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEngineFailure(Engine engine) {
        ClientConnectionRemotelyClosedException failureCause = engine.connection().getRemoteCondition() != null ? ClientExceptionSupport.convertToConnectionClosedException(engine.connection().getRemoteCondition()) : (engine.failureCause() != null ? ClientExceptionSupport.convertToConnectionClosedException(engine.failureCause()) : new ClientConnectionRemotelyClosedException("Unknown error led to connection disconnect"));
        LOG.trace("Engine reports failure with error: {}", (Object)failureCause.getMessage());
        if (this.isReconnectAllowed(failureCause)) {
            engine.shutdownHandler(null);
            LOG.info("Connection {} interrupted to server: {}:{}", new Object[]{this.getId(), this.transport.getHost(), this.transport.getPort()});
            this.submitDisconnectionEvent(this.options.interruptedHandler(), this.transport.getHost(), this.transport.getPort(), failureCause);
            try {
                ReconnectLocation remoteLocation = this.reconnectPool.getNext();
                this.initializeProtonResources(remoteLocation);
                this.scheduleReconnect(remoteLocation);
            }
            catch (ClientException initError) {
                FAILURE_CAUSE_UPDATER.compareAndSet(this, null, ClientExceptionSupport.createOrPassthroughFatal(initError));
                this.engine.shutdown();
            }
            finally {
                engine.shutdown();
            }
        } else {
            FAILURE_CAUSE_UPDATER.compareAndSet(this, null, failureCause);
            engine.shutdown();
        }
    }

    private void handleEngineShutdown(Engine engine) {
        try {
            this.protonConnection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.transport.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.transport.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ioContext.shutdownAsync();
        if (this.failureCause != null) {
            this.openFuture.failed(this.failureCause);
            this.closeFuture.complete(this);
            LOG.warn("Connection {} has failed due to: {}", (Object)this.getId(), this.failureCause != null ? this.failureCause.getClass().getSimpleName() + " -> " + this.failureCause.getMessage() : "No failure details provided.");
            this.submitDisconnectionEvent(this.options.disconnectedHandler(), this.transport.getHost(), this.transport.getPort(), this.failureCause);
        } else {
            this.openFuture.complete(this);
            this.closeFuture.complete(this);
        }
        this.client.unregisterConnection(this);
    }

    private void submitConnectionEvent(BiConsumer<Connection, ConnectionEvent> handler, String host, int port, ClientIOException cause) {
        if (handler != null) {
            try {
                this.notifications.submit(() -> {
                    try {
                        handler.accept(this, new ConnectionEvent(host, port));
                    }
                    catch (Exception ex) {
                        LOG.trace("User supplied connection life-cycle event handler threw: ", (Throwable)ex);
                    }
                });
            }
            catch (Exception ex) {
                LOG.trace("Error thrown while attempting to submit event notification ", (Throwable)ex);
            }
        }
    }

    private void submitDisconnectionEvent(BiConsumer<Connection, DisconnectionEvent> handler, String host, int port, ClientIOException cause) {
        if (handler != null) {
            try {
                this.notifications.submit(() -> {
                    try {
                        handler.accept(this, new DisconnectionEvent(host, port, cause));
                    }
                    catch (Exception ex) {
                        LOG.trace("User supplied disconnection life-cycle event handler threw: ", (Throwable)ex);
                    }
                });
            }
            catch (Exception ex) {
                LOG.trace("Error thrown while attempting to submit event notification ", (Throwable)ex);
            }
        }
    }

    private Engine configureEngineSaslSupport() {
        if (this.options.saslOptions().saslEnabled()) {
            SaslMechanismSelector mechSelector = new SaslMechanismSelector(ClientConversionSupport.toSymbolSet(this.options.saslOptions().allowedMechanisms()));
            this.engine.saslDriver().client().setListener((SaslClientListener)new SaslAuthenticator(mechSelector, new SaslCredentialsProvider(){

                public String vhost() {
                    return ClientConnection.this.options.virtualHost();
                }

                public String username() {
                    return ClientConnection.this.options.user();
                }

                public String password() {
                    return ClientConnection.this.options.password();
                }

                public Principal localPrincipal() {
                    return ClientConnection.this.transport.getLocalPrincipal();
                }
            }));
        }
        return this.engine;
    }

    private void initializeProtonResources(ReconnectLocation location) throws ClientException {
        this.engine = this.options.saslOptions().saslEnabled() ? EngineFactory.PROTON.createEngine() : EngineFactory.PROTON.createNonSaslEngine();
        if (this.options.traceFrames()) {
            this.engine.configuration().setTraceFrames(true);
            if (!this.engine.configuration().isTraceFrames()) {
                LOG.warn("Connection {} frame tracing was enabled but protocol engine does not support it", (Object)this.getId());
            }
        }
        this.engine.outputHandler(this::handleEngineOutput).shutdownHandler(this::handleEngineShutdown).errorHandler(this::handleEngineFailure);
        this.protonConnection = this.engine.connection();
        if (this.client.containerId() != null) {
            this.protonConnection.setContainerId(this.client.containerId());
        } else {
            this.protonConnection.setContainerId(this.connectionId);
        }
        this.protonConnection.setLinkedResource((Object)this);
        this.protonConnection.setChannelMax(this.options.channelMax());
        this.protonConnection.setMaxFrameSize((long)this.options.maxFrameSize());
        this.protonConnection.setHostname(location.getHost());
        this.protonConnection.setIdleTimeout((long)((int)this.options.idleTimeout()));
        this.protonConnection.setOfferedCapabilities(ClientConversionSupport.toSymbolArray(this.options.offeredCapabilities()));
        this.protonConnection.setDesiredCapabilities(ClientConversionSupport.toSymbolArray(this.options.desiredCapabilities()));
        this.protonConnection.setProperties(ClientConversionSupport.toSymbolKeyedMap(this.options.properties()));
        ((org.apache.qpid.protonj2.engine.Connection)((org.apache.qpid.protonj2.engine.Connection)((org.apache.qpid.protonj2.engine.Connection)this.protonConnection.localOpenHandler(this::handleLocalOpen)).localCloseHandler(this::handleLocalClose)).openHandler(this::handleRemoteOpen)).closeHandler(this::handleRemoteClose);
        this.configureEngineSaslSupport();
    }

    private ClientSession lazyCreateConnectionSession() throws ClientException {
        if (this.connectionSession == null) {
            this.connectionSession = this.sessionBuilder.session(null).open();
        }
        return this.connectionSession;
    }

    private Sender lazyCreateConnectionSender() throws ClientException {
        if (this.connectionSender == null) {
            if (this.openFuture.isComplete()) {
                this.checkAnonymousRelaySupported();
            }
            this.connectionSender = this.lazyCreateConnectionSession().internalOpenAnonymousSender(null);
            this.connectionSender.remotelyClosedHandler(sender -> {
                try {
                    sender.closeAsync();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.connectionSender = null;
            });
        }
        return this.connectionSender;
    }

    void checkAnonymousRelaySupported() throws ClientUnsupportedOperationException {
        if (!this.capabilities.anonymousRelaySupported()) {
            throw new ClientUnsupportedOperationException("Anonymous relay support not available from this connection");
        }
    }

    protected void checkClosedOrFailed() throws ClientException {
        if (this.closed > 0) {
            throw new ClientIllegalStateException("The Connection was explicitly closed", this.failureCause);
        }
        if (this.failureCause != null) {
            throw this.failureCause;
        }
    }

    private void waitForOpenToComplete() throws ClientException {
        if (!this.openFuture.isComplete() || this.openFuture.isFailed()) {
            try {
                this.openFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                Thread.interrupted();
                if (this.failureCause != null) {
                    throw this.failureCause;
                }
                throw ClientExceptionSupport.createNonFatalOrPassthrough(e.getCause());
            }
        }
    }

    private void attemptConnection(ReconnectLocation location) {
        try {
            ++this.reconnectAttempts;
            this.transport = this.ioContext.newTransport();
            LOG.trace("Connection {} Attempting connection to remote {}:{}", new Object[]{this.getId(), location.getHost(), location.getPort()});
            this.transport.connect(location.getHost(), location.getPort(), new ClientTransportListener(this, this.engine));
        }
        catch (Throwable error) {
            this.engine.engineFailed((Throwable)ClientExceptionSupport.createOrPassthroughFatal(error));
        }
    }

    private void scheduleReconnect(ReconnectLocation location) {
        int warnInterval = this.options.reconnectOptions().warnAfterReconnectAttempts();
        if (this.reconnectAttempts > 0L && warnInterval > 0 && this.reconnectAttempts % (long)warnInterval == 0L) {
            LOG.warn("Connection {}: Failed to connect after: {} attempt(s) continuing to retry.", (Object)this.getId(), (Object)this.reconnectAttempts);
        }
        if (this.totalConnections == 0L) {
            if (this.reconnectAttempts == 0L) {
                LOG.trace("Initial connect attempt will be performed immediately");
                this.executor.execute(() -> this.attemptConnection(location));
            } else {
                long delay = this.nextReconnectDelay();
                LOG.trace("Next connect attempt will be in {} milliseconds", (Object)delay);
                this.executor.schedule(() -> this.attemptConnection(location), delay, TimeUnit.MILLISECONDS);
            }
        } else if (this.reconnectAttempts == 0L) {
            LOG.trace("Initial reconnect attempt will be performed immediately");
            this.executor.execute(() -> this.attemptConnection(location));
        } else {
            long delay = this.nextReconnectDelay();
            LOG.trace("Next reconnect attempt will be in {} milliseconds", (Object)delay);
            this.executor.schedule(() -> this.attemptConnection(location), delay, TimeUnit.MILLISECONDS);
        }
    }

    private void connectionEstablished() {
        ++this.totalConnections;
        this.nextReconnectDelay = -1L;
        this.reconnectAttempts = 0L;
    }

    private boolean isLimitExceeded() {
        int reconnectLimit = this.reconnectAttemptLimit();
        return reconnectLimit != -1 && this.reconnectAttempts >= (long)reconnectLimit;
    }

    private boolean isReconnectAllowed(ClientException cause) {
        if (this.options.reconnectOptions().reconnectEnabled() && !this.isClosed()) {
            if (this.isStoppageCause(cause)) {
                return false;
            }
            return !this.isLimitExceeded();
        }
        return false;
    }

    private boolean isStoppageCause(ClientException cause) {
        if (cause instanceof ClientConnectionSecuritySaslException) {
            ClientConnectionSecuritySaslException saslFailure = (ClientConnectionSecuritySaslException)cause;
            return !saslFailure.isSysTempFailure();
        }
        return cause instanceof ClientConnectionSecurityException;
    }

    private int reconnectAttemptLimit() {
        int maxReconnectValue = this.options.reconnectOptions().maxReconnectAttempts();
        if (this.totalConnections == 0L && this.options.reconnectOptions().maxInitialConnectionAttempts() != -1) {
            maxReconnectValue = this.options.reconnectOptions().maxInitialConnectionAttempts();
        }
        return maxReconnectValue;
    }

    private long nextReconnectDelay() {
        if (this.nextReconnectDelay == -1L) {
            this.nextReconnectDelay = this.options.reconnectOptions().reconnectDelay();
        }
        if (this.options.reconnectOptions().useReconnectBackOff() && this.reconnectAttempts > 1L) {
            this.nextReconnectDelay = (long)((double)this.nextReconnectDelay * this.options.reconnectOptions().reconnectBackOffMultiplier());
            if (this.nextReconnectDelay > (long)this.options.reconnectOptions().maxReconnectDelay()) {
                this.nextReconnectDelay = this.options.reconnectOptions().maxReconnectDelay();
            }
        }
        return this.nextReconnectDelay;
    }
}

