/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.discovery.multicast;

import java.net.URI;
import java.util.Map;
import org.apache.qpid.jms.provider.discovery.DiscoveryAgent;
import org.apache.qpid.jms.provider.discovery.DiscoveryAgentFactory;
import org.apache.qpid.jms.provider.discovery.multicast.MulticastDiscoveryAgent;
import org.apache.qpid.jms.provider.discovery.multicast.PacketParser;
import org.apache.qpid.jms.provider.discovery.multicast.PacketParserFactory;
import org.apache.qpid.jms.util.PropertyUtil;
import org.apache.qpid.jms.util.URISupport;

public class MulticastDiscoveryAgentFactory
extends DiscoveryAgentFactory {
    private static final String DEFAULT_SERVICE = "activemq";

    @Override
    public DiscoveryAgent createDiscoveryAgent(URI discoveryURI) throws Exception {
        MulticastDiscoveryAgent agent = new MulticastDiscoveryAgent(discoveryURI);
        Map options = URISupport.parseParameters((URI)discoveryURI);
        if (!(options = PropertyUtil.setProperties((Object)agent, (Map)options)).isEmpty()) {
            String msg = " Not all options could be set on the Multicast discovery. agent.  Check the options are spelled correctly. Unused parameters=[" + options + "]. This agent cannot be started.";
            throw new IllegalArgumentException(msg);
        }
        String service = agent.getService();
        if (service == null || service.isEmpty()) {
            service = DEFAULT_SERVICE;
        }
        PacketParser packetParser = PacketParserFactory.createAgent(service);
        packetParser.setGroup(agent.getGroup());
        agent.setParser(packetParser);
        return agent;
    }

    @Override
    public String getName() {
        return "multicast";
    }
}

