/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.amqp.messaging;

import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.proton.amqp.Symbol;

public enum TerminusExpiryPolicy {
    LINK_DETACH("link-detach"),
    SESSION_END("session-end"),
    CONNECTION_CLOSE("connection-close"),
    NEVER("never");

    private Symbol _policy;
    private static final Map<Symbol, TerminusExpiryPolicy> _map;

    private TerminusExpiryPolicy(String policy) {
        this._policy = Symbol.valueOf(policy);
    }

    public Symbol getPolicy() {
        return this._policy;
    }

    public static TerminusExpiryPolicy valueOf(Symbol policy) {
        TerminusExpiryPolicy expiryPolicy = _map.get(policy);
        if (expiryPolicy == null) {
            throw new IllegalArgumentException("Unknown TerminusExpiryPolicy: " + policy);
        }
        return expiryPolicy;
    }

    static {
        _map = new HashMap<Symbol, TerminusExpiryPolicy>();
        _map.put(LINK_DETACH.getPolicy(), LINK_DETACH);
        _map.put(SESSION_END.getPolicy(), SESSION_END);
        _map.put(CONNECTION_CLOSE.getPolicy(), CONNECTION_CLOSE);
        _map.put(NEVER.getPolicy(), NEVER);
    }
}

