/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport;

import java.util.List;
import org.apache.qpid.transport.DeliveryProperties;
import org.apache.qpid.transport.MessageProperties;
import org.apache.qpid.transport.Struct;

public class Header {
    private final DeliveryProperties _deliveryProps;
    private final MessageProperties _messageProps;
    private final List<Struct> _nonStandardProps;

    public Header(DeliveryProperties deliveryProps, MessageProperties messageProps) {
        this(deliveryProps, messageProps, null);
    }

    public Header(DeliveryProperties deliveryProps, MessageProperties messageProps, List<Struct> nonStandardProps) {
        this._deliveryProps = deliveryProps;
        this._messageProps = messageProps;
        this._nonStandardProps = nonStandardProps;
    }

    public Struct[] getStructs() {
        int size = 0;
        if (this._deliveryProps != null) {
            ++size;
        }
        if (this._messageProps != null) {
            ++size;
        }
        if (this._nonStandardProps != null) {
            size += this._nonStandardProps.size();
        }
        Struct[] structs = new Struct[size];
        int index = 0;
        if (this._deliveryProps != null) {
            structs[index++] = this._deliveryProps;
        }
        if (this._messageProps != null) {
            structs[index++] = this._messageProps;
        }
        if (this._nonStandardProps != null) {
            for (Struct struct : this._nonStandardProps) {
                structs[index++] = struct;
            }
        }
        return structs;
    }

    public DeliveryProperties getDeliveryProperties() {
        return this._deliveryProps;
    }

    public MessageProperties getMessageProperties() {
        return this._messageProps;
    }

    public List<Struct> getNonStandardProperties() {
        return this._nonStandardProps;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(" Header(");
        boolean first = true;
        if (this._deliveryProps != null) {
            first = false;
            str.append(this._deliveryProps);
        }
        if (this._messageProps != null) {
            if (first) {
                first = false;
            } else {
                str.append(", ");
            }
            str.append(this._messageProps);
        }
        if (this._nonStandardProps != null) {
            for (Struct s : this._nonStandardProps) {
                if (first) {
                    first = false;
                } else {
                    str.append(", ");
                }
                str.append(s);
            }
        }
        str.append(')');
        return str.toString();
    }
}

