/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.qpid.QpidException;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyImpl;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.EncodableAMQDataBlock;
import org.apache.qpid.framing.EncodingUtils;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.ServerMethodProcessor;

public class ConnectionStartOkBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 10;
    public static final int METHOD_ID = 11;
    private final FieldTable _clientProperties;
    private final AMQShortString _mechanism;
    private final byte[] _response;
    private final AMQShortString _locale;

    public ConnectionStartOkBody(FieldTable clientProperties, AMQShortString mechanism, byte[] response, AMQShortString locale) {
        this._clientProperties = clientProperties;
        this._mechanism = mechanism;
        this._response = response;
        this._locale = locale;
    }

    @Override
    public int getClazz() {
        return 10;
    }

    @Override
    public int getMethod() {
        return 11;
    }

    public final FieldTable getClientProperties() {
        return this._clientProperties;
    }

    public final AMQShortString getMechanism() {
        return this._mechanism;
    }

    public final byte[] getResponse() {
        return this._response;
    }

    public final AMQShortString getLocale() {
        return this._locale;
    }

    @Override
    protected int getBodySize() {
        int size = 0;
        size += this.getSizeOf(this._clientProperties);
        size += this.getSizeOf(this._mechanism);
        size += this.getSizeOf(this._response);
        return size += this.getSizeOf(this._locale);
    }

    @Override
    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeFieldTable(buffer, this._clientProperties);
        this.writeAMQShortString(buffer, this._mechanism);
        this.writeBytes(buffer, this._response);
        this.writeAMQShortString(buffer, this._locale);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchConnectionStartOk(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[ConnectionStartOkBodyImpl: ");
        buf.append("clientProperties=");
        buf.append(this.getClientProperties());
        buf.append(", ");
        buf.append("mechanism=");
        buf.append(this.getMechanism());
        buf.append(", ");
        buf.append("response=");
        buf.append(this.getResponse() == null ? "null" : Arrays.toString(this.getResponse()));
        buf.append(", ");
        buf.append("locale=");
        buf.append(this.getLocale());
        buf.append("]");
        return buf.toString();
    }

    public static void process(ByteBuffer in, ServerMethodProcessor dispatcher) throws AMQFrameDecodingException {
        FieldTable clientProperties = EncodingUtils.readFieldTable(in);
        AMQShortString mechanism = AMQShortString.readAMQShortString(in);
        byte[] response = EncodingUtils.readBytes(in);
        AMQShortString locale = AMQShortString.readAMQShortString(in);
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveConnectionStartOk(clientProperties, mechanism, response, locale);
        }
        if (clientProperties != null) {
            clientProperties.clearEncodedForm();
        }
    }
}

