/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import javax.jms.JMSException;
import javax.jms.TemporaryQueue;
import org.apache.qpid.client.AMQQueue;
import org.apache.qpid.client.AMQSession;
import org.apache.qpid.client.TemporaryDestination;

final class AMQTemporaryQueue
extends AMQQueue
implements TemporaryQueue,
TemporaryDestination {
    private static final long serialVersionUID = -5457866720195625708L;
    private final AMQSession _session;
    private boolean _deleted;

    public AMQTemporaryQueue(AMQSession session) {
        super(session.getTemporaryQueueExchangeName(), session.createTemporaryQueueName(), true);
        this._session = session;
    }

    @Override
    public synchronized void delete() throws JMSException {
        if (this._session.hasConsumer(this)) {
            throw new JMSException("Temporary Queue has consumers so cannot be deleted");
        }
        try {
            this._session.deleteTemporaryDestination(this);
        }
        finally {
            this._deleted = true;
        }
    }

    @Override
    public AMQSession getSession() {
        return this._session;
    }

    @Override
    public boolean isDeleted() {
        return this._deleted;
    }
}

