/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.nio.ByteBuffer;
import org.apache.qpid.QpidException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyImpl;
import org.apache.qpid.framing.EncodableAMQDataBlock;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.ServerChannelMethodProcessor;
import org.apache.qpid.util.ByteBufferUtils;

public class BasicQosBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 60;
    public static final int METHOD_ID = 10;
    private final long _prefetchSize;
    private final int _prefetchCount;
    private final byte _bitfield0;

    public BasicQosBody(long prefetchSize, int prefetchCount, boolean global) {
        this._prefetchSize = prefetchSize;
        this._prefetchCount = prefetchCount;
        byte bitfield0 = 0;
        if (global) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        this._bitfield0 = bitfield0;
    }

    @Override
    public int getClazz() {
        return 60;
    }

    @Override
    public int getMethod() {
        return 10;
    }

    public final long getPrefetchSize() {
        return this._prefetchSize;
    }

    public final int getPrefetchCount() {
        return this._prefetchCount;
    }

    public final boolean getGlobal() {
        return (this._bitfield0 & 1) != 0;
    }

    @Override
    protected int getBodySize() {
        int size = 7;
        return size;
    }

    @Override
    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeUnsignedInteger(buffer, this._prefetchSize);
        this.writeUnsignedShort(buffer, this._prefetchCount);
        this.writeBitfield(buffer, this._bitfield0);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchBasicQos(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[BasicQosBodyImpl: ");
        buf.append("prefetchSize=");
        buf.append(this.getPrefetchSize());
        buf.append(", ");
        buf.append("prefetchCount=");
        buf.append(this.getPrefetchCount());
        buf.append(", ");
        buf.append("global=");
        buf.append(this.getGlobal());
        buf.append("]");
        return buf.toString();
    }

    public static void process(ByteBuffer buffer, ServerChannelMethodProcessor dispatcher) {
        boolean global;
        long prefetchSize = ByteBufferUtils.getUnsignedInt(buffer);
        int prefetchCount = ByteBufferUtils.getUnsignedShort(buffer);
        boolean bl = global = (buffer.get() & 1) == 1;
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveBasicQos(prefetchSize, prefetchCount, global);
        }
    }
}

