/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.group;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.adapter.FileBasedGroupProvider;
import org.apache.qpid.server.security.group.GroupDatabase;
import org.apache.qpid.server.util.FileHelper;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileGroupDatabase
implements GroupDatabase {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileGroupDatabase.class);
    private final Map<String, Set<String>> _groupToUserMap;
    private final Map<String, Set<String>> _userToGroupMap;
    private final FileBasedGroupProvider<?> _groupProvider;
    private String _groupFile;

    public FileGroupDatabase(FileBasedGroupProvider<?> groupProvider) {
        this._groupProvider = groupProvider;
        this._groupToUserMap = new ConcurrentHashMap<String, Set<String>>();
        this._userToGroupMap = new ConcurrentHashMap<String, Set<String>>();
    }

    @Override
    public Set<String> getAllGroups() {
        return Collections.unmodifiableSet(this._groupToUserMap.keySet());
    }

    public synchronized void setGroupFile(String groupFile) throws IOException {
        File file = new File(groupFile);
        if (!file.canRead()) {
            throw new FileNotFoundException(groupFile + " cannot be found or is not readable");
        }
        this.readGroupFile(groupFile);
    }

    @Override
    public Set<String> getUsersInGroup(String group) {
        if (group == null) {
            LOGGER.warn("Requested user set for null group. Returning empty set.");
            return Collections.emptySet();
        }
        Set<String> set = this._groupToUserMap.get(this.keySearch(this._groupToUserMap.keySet(), group));
        if (set == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(set);
    }

    @Override
    public synchronized void addUserToGroup(String user, String group) {
        String groupKey = this.keySearch(this._groupToUserMap.keySet(), group);
        Set<String> groupUsers = this._groupToUserMap.get(groupKey);
        String userKey = this.keySearch(this._userToGroupMap.keySet(), user);
        if (groupUsers == null) {
            throw new IllegalArgumentException(String.format("Group %s does not exist so could not add %s to it", group, user));
        }
        if (groupUsers.contains(userKey)) {
            throw new IllegalConfigurationException(String.format("Group member with name '%s' already exists", user));
        }
        String groupUserKey = this.keySearch(groupUsers, user);
        if (!userKey.equals(groupUserKey)) {
            throw new IllegalConfigurationException(String.format("Inconsistent data: user  key '%s' is not equal to a group key '%s'", userKey, groupKey));
        }
        groupUsers.add(groupUserKey);
        Set<String> groups = this._userToGroupMap.get(userKey);
        if (groups == null) {
            groups = new ConcurrentSkipListSet<String>();
            this._userToGroupMap.put(user, groups);
        }
        groups.add(groupKey);
        this.update();
    }

    @Override
    public synchronized void removeUserFromGroup(String user, String group) {
        Set<String> users = this._groupToUserMap.get(this.keySearch(this._groupToUserMap.keySet(), group));
        if (users == null) {
            throw new IllegalArgumentException("Group " + group + " does not exist so could not remove " + user + " from it");
        }
        users.remove(this.keySearch(users, user));
        Set<String> groups = this._userToGroupMap.get(this.keySearch(this._userToGroupMap.keySet(), user));
        if (groups != null) {
            groups.remove(this.keySearch(groups, group));
        }
        this.update();
    }

    @Override
    public Set<String> getGroupsForUser(String user) {
        if (user == null) {
            LOGGER.warn("Requested group set for null user. Returning empty set.");
            return Collections.emptySet();
        }
        Set<String> groups = this._userToGroupMap.get(this.keySearch(this._userToGroupMap.keySet(), user));
        if (groups == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(groups);
    }

    @Override
    public synchronized void createGroup(String group) {
        if (this.exists(group, this._groupToUserMap.keySet())) {
            throw new IllegalConfigurationException(String.format("Group with name '%s' already exists", group));
        }
        ConcurrentSkipListSet users = new ConcurrentSkipListSet();
        this._groupToUserMap.put(group, users);
        this.update();
    }

    private boolean exists(String searchString, Set<String> set) {
        if (!this._groupProvider.isCaseSensitive()) {
            for (String key : set) {
                if (!key.equalsIgnoreCase(searchString)) continue;
                return true;
            }
            return false;
        }
        return set.contains(searchString);
    }

    @Override
    public synchronized void removeGroup(String group) {
        this._groupToUserMap.remove(this.keySearch(this._groupToUserMap.keySet(), group));
        for (Set<String> groupsForUser : this._userToGroupMap.values()) {
            groupsForUser.remove(this.keySearch(groupsForUser, group));
        }
        this.update();
    }

    private synchronized void update() {
        if (this._groupFile != null) {
            try {
                this.writeGroupFile(this._groupFile);
            }
            catch (IOException e) {
                throw new ServerScopedRuntimeException("Unable to persist change to file " + this._groupFile, e);
            }
        }
    }

    private synchronized void readGroupFile(String groupFile) throws IOException {
        this._groupFile = groupFile;
        this._groupToUserMap.clear();
        this._userToGroupMap.clear();
        Properties propertiesFile = new Properties();
        try (FileInputStream fileInputStream = new FileInputStream(groupFile);){
            propertiesFile.load(fileInputStream);
        }
        for (String propertyName : propertiesFile.stringPropertyNames()) {
            this.validatePropertyNameIsGroupName(propertyName);
            String groupName = propertyName.replaceAll("\\.users$", "");
            String userString = propertiesFile.getProperty(propertyName);
            ConcurrentSkipListSet<String> userSet = this.buildUserSetFromCommaSeparateValue(userString);
            this._groupToUserMap.put(groupName, userSet);
            for (String userName : userSet) {
                Set<String> groupsForThisUser = this._userToGroupMap.get(this.keySearch(this._userToGroupMap.keySet(), userName));
                if (groupsForThisUser == null) {
                    groupsForThisUser = new ConcurrentSkipListSet<String>();
                    this._userToGroupMap.put(userName, groupsForThisUser);
                }
                groupsForThisUser.add(groupName);
            }
        }
    }

    private synchronized void writeGroupFile(String groupFile) throws IOException {
        Properties propertiesFile = new Properties();
        for (String group : this._groupToUserMap.keySet()) {
            Set<String> users = this._groupToUserMap.get(this.keySearch(this._groupToUserMap.keySet(), group));
            String userList = Joiner.on((String)",").useForNull("").join(users);
            propertiesFile.setProperty(group + ".users", userList);
        }
        new FileHelper().writeFileSafely(new File(groupFile).toPath(), file -> {
            String comment = "Written " + new Date();
            try (FileOutputStream fileOutputStream = new FileOutputStream((File)file);){
                propertiesFile.store(fileOutputStream, comment);
            }
        });
    }

    private void validatePropertyNameIsGroupName(String propertyName) {
        if (!propertyName.endsWith(".users")) {
            throw new IllegalArgumentException("Invalid definition with name '" + propertyName + "'. Group definitions must end with suffix '.users'");
        }
    }

    private ConcurrentSkipListSet<String> buildUserSetFromCommaSeparateValue(String userString) {
        String[] users = userString.split(",");
        ConcurrentSkipListSet<String> userSet = new ConcurrentSkipListSet<String>();
        for (String user : users) {
            String trimmed = user.trim();
            if (trimmed.isEmpty()) continue;
            userSet.add(trimmed);
        }
        return userSet;
    }

    private String keySearch(Set<String> set, String requiredKey) {
        if (!this._groupProvider.isCaseSensitive()) {
            for (String key : set) {
                if (!key.equalsIgnoreCase(requiredKey)) continue;
                return key;
            }
        }
        return requiredKey;
    }
}

