/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.DerivedAttribute;
import org.apache.qpid.server.model.KeyStore;
import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.model.ManagedContextDependency;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedOperation;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.model.TrustStore;
import org.apache.qpid.server.security.SubjectCreator;

@ManagedContextDependency(value={"qpid.security.tls.protocolAllowList", "qpid.security.tls.cipherSuiteDenyList"})
@ManagedObject(description="<p>The Broker supports configuration of Ports to specify the particular AMQP messaging and HTTP management connectivity it offers for use.</p><p>Each Port is configured with the particular Protocols and Transports it supports, as well as the Authentication Provider to be used to authenticate connections. Where SSL is in use, the Port configuration also defines which Keystore to use and (where supported) which TrustStore(s) and whether Client Certificates should be requested/required.</p>", amqpName="org.apache.qpid.Port")
public interface Port<X extends Port<X>>
extends ConfiguredObject<X> {
    public static final String CLASS_DESCRIPTION = "<p>The Broker supports configuration of Ports to specify the particular AMQP messaging and HTTP management connectivity it offers for use.</p><p>Each Port is configured with the particular Protocols and Transports it supports, as well as the Authentication Provider to be used to authenticate connections. Where SSL is in use, the Port configuration also defines which Keystore to use and (where supported) which TrustStore(s) and whether Client Certificates should be requested/required.</p>";
    public static final String BINDING_ADDRESS = "bindingAddress";
    public static final String PORT = "port";
    public static final String PROTOCOLS = "protocols";
    public static final String TRANSPORTS = "transports";
    public static final String TCP_NO_DELAY = "tcpNoDelay";
    public static final String NEED_CLIENT_AUTH = "needClientAuth";
    public static final String WANT_CLIENT_AUTH = "wantClientAuth";
    public static final String AUTHENTICATION_PROVIDER = "authenticationProvider";
    public static final String KEY_STORE = "keyStore";
    public static final String TRUST_STORES = "trustStores";
    public static final String CLIENT_CERT_RECORDER = "clientCertRecorder";
    public static final String DEFAULT_BINDING_ADDRESS = "*";
    public static final String CONNECTION_MAXIMUM_AUTHENTICATION_DELAY = "connection.maximumAuthenticationDelay";
    @ManagedContextDefault(name="connection.maximumAuthenticationDelay")
    public static final long DEFAULT_MAX_CONNECTION_AUTHENTICATION_DELAY = 10000L;
    public static final String ALLOW_CONFIDENTIAL_OPERATIONS_ON_INSECURE_CHANNELS = "allowConfidentialOperationsOnInsecureChannels";

    @ManagedAttribute(mandatory=true, description="Port used to accept incoming connections. A value of 0 will cause a dynamically allocated port to be assigned.")
    public int getPort();

    @ManagedAttribute(defaultValue="false", description="If true allow operations which may return confidential information to be executed on insecure connections")
    public boolean isAllowConfidentialOperationsOnInsecureChannels();

    @DerivedAttribute(description="Actual port used to accept incoming connections. Will be -1 if the port is not currently bound.")
    public int getBoundPort();

    @ManagedAttribute
    public Set<Protocol> getProtocols();

    @ManagedAttribute(defaultValue="TCP")
    public Set<Transport> getTransports();

    @ManagedAttribute
    public KeyStore getKeyStore();

    @ManagedAttribute
    public Collection<TrustStore> getTrustStores();

    @DerivedAttribute
    public List<String> getTlsProtocolAllowList();

    @DerivedAttribute
    public List<String> getTlsProtocolDenyList();

    @DerivedAttribute
    public List<String> getTlsCipherSuiteAllowList();

    @DerivedAttribute
    public List<String> getTlsCipherSuiteDenyList();

    @ManagedAttribute(defaultValue="*", description="The network interface this port binds to expressed as an IP address or ahostname.  If null or * then bind to all interfaces.")
    public String getBindingAddress();

    public SSLContext getSSLContext();

    @ManagedAttribute
    public boolean getNeedClientAuth();

    @ManagedAttribute
    public boolean getWantClientAuth();

    @ManagedAttribute
    public TrustStore<?> getClientCertRecorder();

    @ManagedAttribute(mandatory=true)
    public AuthenticationProvider<?> getAuthenticationProvider();

    @DerivedAttribute(description="TLS session timeout in seconds")
    public int getTLSSessionTimeout();

    @DerivedAttribute(description="TLS session cache size")
    public int getTLSSessionCacheSize();

    public Collection<Connection> getConnections();

    public void start();

    public ListenableFuture<Void> startAsync();

    public NamedAddressSpace getAddressSpace(String var1);

    public SubjectCreator getSubjectCreator(boolean var1, String var2);

    @DerivedAttribute(description="Indicates whether TLS transport support is created.")
    public boolean isTlsSupported();

    @ManagedOperation(description="Updates port TLS support without affecting existing connections. The TLS changes are applied to new connections only. Returns true if TLS support is successfully updated.", nonModifying=true, changesConfiguredObjectState=false)
    public boolean updateTLS();
}

