/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10.transport;

import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v0_10.transport.Decoder;
import org.apache.qpid.server.protocol.v0_10.transport.Encoder;
import org.apache.qpid.server.protocol.v0_10.transport.Header;
import org.apache.qpid.server.protocol.v0_10.transport.MessageAcceptMode;
import org.apache.qpid.server.protocol.v0_10.transport.MessageAcquireMode;
import org.apache.qpid.server.protocol.v0_10.transport.Method;
import org.apache.qpid.server.protocol.v0_10.transport.MethodDelegate;
import org.apache.qpid.server.protocol.v0_10.transport.Option;

public final class MessageTransfer
extends Method {
    public static final int TYPE = 1025;
    private int _bodySize;
    private short packing_flags = 0;
    private String destination;
    private MessageAcceptMode acceptMode;
    private MessageAcquireMode acquireMode;
    private Header header;
    private QpidByteBuffer _body;

    @Override
    public final int getStructType() {
        return 1025;
    }

    @Override
    public final int getSizeWidth() {
        return 0;
    }

    @Override
    public final int getPackWidth() {
        return 2;
    }

    @Override
    public final boolean hasPayload() {
        return true;
    }

    @Override
    public final byte getEncodedTrack() {
        return 3;
    }

    @Override
    public final boolean isConnectionControl() {
        return false;
    }

    public MessageTransfer() {
    }

    public MessageTransfer(String destination, MessageAcceptMode acceptMode, MessageAcquireMode acquireMode, Header header, ByteBuffer body, Option ... options) {
        this(destination, acceptMode, acquireMode, header, QpidByteBuffer.wrap((ByteBuffer)body), options);
    }

    public MessageTransfer(String destination, MessageAcceptMode acceptMode, MessageAcquireMode acquireMode, Header header, QpidByteBuffer body, Option ... _options) {
        if (destination != null) {
            this.setDestination(destination);
        }
        if (acceptMode != null) {
            this.setAcceptMode(acceptMode);
        }
        if (acquireMode != null) {
            this.setAcquireMode(acquireMode);
        }
        this.setHeader(header);
        this.setBody(body);
        block6: for (int i = 0; i < _options.length; ++i) {
            switch (_options[i]) {
                case SYNC: {
                    this.setSync(true);
                    continue block6;
                }
                case BATCH: {
                    this.setBatch(true);
                    continue block6;
                }
                case UNRELIABLE: {
                    this.setUnreliable(true);
                    continue block6;
                }
                case NONE: {
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("invalid option: " + _options[i]);
                }
            }
        }
    }

    @Override
    public <C> void dispatch(C context, MethodDelegate<C> delegate) {
        delegate.messageTransfer(context, this);
    }

    public final boolean hasDestination() {
        return (this.packing_flags & 0x100) != 0;
    }

    public final MessageTransfer clearDestination() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFEFF);
        this.destination = null;
        this.setDirty(true);
        return this;
    }

    public final String getDestination() {
        return this.destination;
    }

    public final MessageTransfer setDestination(String value) {
        this.destination = value;
        this.packing_flags = (short)(this.packing_flags | 0x100);
        this.setDirty(true);
        return this;
    }

    public final MessageTransfer destination(String value) {
        return this.setDestination(value);
    }

    public final boolean hasAcceptMode() {
        return (this.packing_flags & 0x200) != 0;
    }

    public final MessageTransfer clearAcceptMode() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFDFF);
        this.acceptMode = null;
        this.setDirty(true);
        return this;
    }

    public final MessageAcceptMode getAcceptMode() {
        return this.acceptMode;
    }

    public final MessageTransfer setAcceptMode(MessageAcceptMode value) {
        this.acceptMode = value;
        this.packing_flags = (short)(this.packing_flags | 0x200);
        this.setDirty(true);
        return this;
    }

    public final MessageTransfer acceptMode(MessageAcceptMode value) {
        return this.setAcceptMode(value);
    }

    public final boolean hasAcquireMode() {
        return (this.packing_flags & 0x400) != 0;
    }

    public final MessageTransfer clearAcquireMode() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFBFF);
        this.acquireMode = null;
        this.setDirty(true);
        return this;
    }

    public final MessageAcquireMode getAcquireMode() {
        return this.acquireMode;
    }

    public final MessageTransfer setAcquireMode(MessageAcquireMode value) {
        this.acquireMode = value;
        this.packing_flags = (short)(this.packing_flags | 0x400);
        this.setDirty(true);
        return this;
    }

    public final MessageTransfer acquireMode(MessageAcquireMode value) {
        return this.setAcquireMode(value);
    }

    @Override
    public final Header getHeader() {
        return this.header;
    }

    @Override
    public final void setHeader(Header header) {
        this.header = header;
    }

    public final MessageTransfer header(Header header) {
        this.setHeader(header);
        return this;
    }

    @Override
    public final QpidByteBuffer getBody() {
        return this._body;
    }

    @Override
    public final void setBody(QpidByteBuffer body) {
        if (body == null) {
            this._bodySize = 0;
            if (this._body != null) {
                this._body.dispose();
            }
            this._body = null;
        } else {
            this._body = body.duplicate();
            this._bodySize = this._body.remaining();
        }
    }

    @Override
    public int getBodySize() {
        return this._bodySize;
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint16(this.packing_flags);
        if ((this.packing_flags & 0x100) != 0) {
            enc.writeStr8(this.destination);
        }
        if ((this.packing_flags & 0x200) != 0) {
            enc.writeUint8(this.acceptMode.getValue());
        }
        if ((this.packing_flags & 0x400) != 0) {
            enc.writeUint8(this.acquireMode.getValue());
        }
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (short)dec.readUint16();
        if ((this.packing_flags & 0x100) != 0) {
            this.destination = dec.readStr8();
        }
        if ((this.packing_flags & 0x200) != 0) {
            this.acceptMode = MessageAcceptMode.get(dec.readUint8());
        }
        if ((this.packing_flags & 0x400) != 0) {
            this.acquireMode = MessageAcquireMode.get(dec.readUint8());
        }
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 0x100) != 0) {
            result.put("destination", this.getDestination());
        }
        if ((this.packing_flags & 0x200) != 0) {
            result.put("acceptMode", (Object)this.getAcceptMode());
        }
        if ((this.packing_flags & 0x400) != 0) {
            result.put("acquireMode", (Object)this.getAcquireMode());
        }
        return result;
    }

    public void dispose() {
        if (this._body != null) {
            this._body.dispose();
            this._body = null;
        }
    }
}

