/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.auth;

import java.security.Principal;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.qpid.server.management.plugin.HttpManagementConfiguration;
import org.apache.qpid.server.management.plugin.HttpManagementUtil;
import org.apache.qpid.server.management.plugin.HttpRequestInteractiveAuthenticator;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.security.SubjectCreator;
import org.apache.qpid.server.security.TokenCarryingPrincipal;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.SubjectAuthenticationResult;
import org.apache.qpid.server.security.auth.manager.KerberosAuthenticationManager;

@PluggableService
public class SpnegoInteractiveAuthenticator
implements HttpRequestInteractiveAuthenticator {
    @Override
    public HttpRequestInteractiveAuthenticator.AuthenticationHandler getAuthenticationHandler(HttpServletRequest request, HttpManagementConfiguration configuration) {
        AuthenticationProvider authenticationProvider = configuration.getAuthenticationProvider(request);
        if (authenticationProvider instanceof KerberosAuthenticationManager) {
            KerberosAuthenticationManager kerberosProvider = (KerberosAuthenticationManager)authenticationProvider;
            return response -> {
                String authorizationHeader = request.getHeader("Authorization");
                AuthenticationResult authenticationResult = kerberosProvider.authenticate(authorizationHeader);
                if (authenticationResult == null || authenticationResult.getStatus() == AuthenticationResult.AuthenticationStatus.ERROR) {
                    response.setHeader("WWW-Authenticate", "Negotiate");
                    response.sendError(401);
                } else {
                    Principal principal = authenticationResult.getMainPrincipal();
                    if (principal instanceof TokenCarryingPrincipal) {
                        ((TokenCarryingPrincipal)principal).getTokens().forEach((arg_0, arg_1) -> ((HttpServletResponse)response).setHeader(arg_0, arg_1));
                    }
                    Port<?> port = configuration.getPort(request);
                    SubjectCreator subjectCreator = port.getSubjectCreator(request.isSecure(), request.getServerName());
                    SubjectAuthenticationResult result = subjectCreator.createResultWithGroups(authenticationResult);
                    Broker broker = (Broker)kerberosProvider.getParent();
                    HttpManagementUtil.createServletConnectionSubjectAssertManagementAccessAndSave(broker, request, result.getSubject());
                    request.getRequestDispatcher("/index.html").forward((ServletRequest)request, (ServletResponse)response);
                }
            };
        }
        return null;
    }

    @Override
    public HttpRequestInteractiveAuthenticator.LogoutHandler getLogoutHandler(HttpServletRequest request, HttpManagementConfiguration configuration) {
        return response -> response.sendRedirect("/logout.html");
    }

    public String getType() {
        return "SPNEGO";
    }
}

