/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhostnode;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.logging.messages.ConfigStoreMessages;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.RemoteReplicationNode;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.store.ConfiguredObjectRecord;
import org.apache.qpid.server.store.ConfiguredObjectRecordImpl;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.VirtualHostStoreUpgraderAndRecoverer;
import org.apache.qpid.server.store.preferences.PreferenceStore;
import org.apache.qpid.server.store.preferences.PreferenceStoreProvider;
import org.apache.qpid.server.virtualhost.QueueManagingVirtualHost;
import org.apache.qpid.server.virtualhostnode.AbstractVirtualHostNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStandardVirtualHostNode<X extends AbstractStandardVirtualHostNode<X>>
extends AbstractVirtualHostNode<X>
implements VirtualHostNode<X> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractStandardVirtualHostNode.class);

    public AbstractStandardVirtualHostNode(Map<String, Object> attributes, Broker<?> parent) {
        super(parent, attributes);
    }

    @Override
    protected ListenableFuture<Void> activate() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Activating virtualhost node " + this);
        }
        this.getConfigurationStore().init(this);
        this.getConfigurationStore().upgradeStoreStructure();
        this.getEventLogger().message(this.getConfigurationStoreLogSubject(), ConfigStoreMessages.CREATED());
        this.writeLocationEventLog();
        this.getEventLogger().message(this.getConfigurationStoreLogSubject(), ConfigStoreMessages.RECOVERY_START());
        VirtualHostStoreUpgraderAndRecoverer upgrader = new VirtualHostStoreUpgraderAndRecoverer(this);
        ConfiguredObjectRecord[] initialRecords = null;
        try {
            initialRecords = this.getInitialRecords();
        }
        catch (IOException e) {
            throw new IllegalConfigurationException("Could not process initial configuration", e);
        }
        boolean isNew = upgrader.upgradeAndRecover(this.getConfigurationStore(), initialRecords);
        if (initialRecords.length > 0) {
            this.setAttributes(Collections.singletonMap("virtualHostInitialConfiguration", "{}"));
        }
        this.getEventLogger().message(this.getConfigurationStoreLogSubject(), ConfigStoreMessages.RECOVERY_COMPLETE());
        VirtualHost host = this.getVirtualHost();
        if (host != null) {
            VirtualHost recoveredHost = host;
            recoveredHost.setFirstOpening(isNew && initialRecords.length == 0);
            ListenableFuture<Void> openFuture = Subject.doAs(this.getSubjectWithAddedSystemRights(), new PrivilegedAction<ListenableFuture<Void>>((QueueManagingVirtualHost)recoveredHost){
                final /* synthetic */ QueueManagingVirtualHost val$recoveredHost;
                {
                    this.val$recoveredHost = queueManagingVirtualHost;
                }

                @Override
                public ListenableFuture<Void> run() {
                    return this.val$recoveredHost.openAsync();
                }
            });
            return openFuture;
        }
        return Futures.immediateFuture(null);
    }

    @Override
    protected ListenableFuture<Void> onDelete() {
        VirtualHost virtualHost = this.getVirtualHost();
        MessageStore messageStore = virtualHost == null ? null : virtualHost.getMessageStore();
        return this.doAfterAlways(this.closeVirtualHostIfExists(), () -> {
            DurableConfigurationStore configurationStore;
            PreferenceStore preferenceStore;
            if (messageStore != null) {
                messageStore.closeMessageStore();
                messageStore.onDelete(virtualHost);
            }
            if (this instanceof PreferenceStoreProvider && (preferenceStore = ((PreferenceStoreProvider)((Object)this)).getPreferenceStore()) != null) {
                preferenceStore.onDelete();
            }
            if ((configurationStore = this.getConfigurationStore()) != null) {
                configurationStore.closeConfigurationStore();
                configurationStore.onDelete(this);
            }
            this.onCloseOrDelete();
        });
    }

    @Override
    public QueueManagingVirtualHost<?> getVirtualHost() {
        VirtualHost<?> vhost = super.getVirtualHost();
        if (vhost == null || vhost instanceof QueueManagingVirtualHost) {
            return (QueueManagingVirtualHost)vhost;
        }
        throw new IllegalStateException(this + " has a virtual host which is not a queue managing virtual host " + vhost);
    }

    @Override
    protected ConfiguredObjectRecord enrichInitialVirtualHostRootRecord(ConfiguredObjectRecord vhostRecord) {
        ConfiguredObjectRecord replacementRecord;
        if (vhostRecord.getAttributes().get("name") == null) {
            LinkedHashMap<String, Object> updatedAttributes = new LinkedHashMap<String, Object>(vhostRecord.getAttributes());
            updatedAttributes.put("name", this.getName());
            if (!updatedAttributes.containsKey("modelVersion")) {
                updatedAttributes.put("modelVersion", this.getBroker().getModelVersion());
            }
            replacementRecord = new ConfiguredObjectRecordImpl(vhostRecord.getId(), vhostRecord.getType(), updatedAttributes, vhostRecord.getParents());
        } else if (vhostRecord.getAttributes().get("modelVersion") == null) {
            LinkedHashMap<String, Object> updatedAttributes = new LinkedHashMap<String, Object>(vhostRecord.getAttributes());
            updatedAttributes.put("modelVersion", this.getBroker().getModelVersion());
            replacementRecord = new ConfiguredObjectRecordImpl(vhostRecord.getId(), vhostRecord.getType(), updatedAttributes, vhostRecord.getParents());
        } else {
            replacementRecord = vhostRecord;
        }
        return replacementRecord;
    }

    protected abstract void writeLocationEventLog();

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.getId() + ", name=" + this.getName() + ", state=" + this.getState() + "]";
    }

    @Override
    public Collection<RemoteReplicationNode<?>> getRemoteReplicationNodes() {
        return Collections.emptyList();
    }

    @Override
    protected void validateOnCreate() {
        super.validateOnCreate();
        DurableConfigurationStore store = this.createConfigurationStore();
        if (store != null) {
            try {
                store.init(this);
            }
            catch (Exception e) {
                throw new IllegalConfigurationException("Cannot open node configuration store:" + e.getMessage(), e);
            }
            finally {
                try {
                    store.closeConfigurationStore();
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to close database", (Throwable)e);
                }
            }
        }
    }
}

