/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhost;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.logging.EventLogger;
import org.apache.qpid.server.logging.messages.TransactionLogMessages;
import org.apache.qpid.server.logging.subjects.MessageStoreLogSubject;
import org.apache.qpid.server.message.MessageReference;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.plugin.MessageMetaDataType;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.store.MessageEnqueueRecord;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.store.Transaction;
import org.apache.qpid.server.store.handler.DistributedTransactionHandler;
import org.apache.qpid.server.store.handler.MessageHandler;
import org.apache.qpid.server.store.handler.MessageInstanceHandler;
import org.apache.qpid.server.transport.util.Functions;
import org.apache.qpid.server.txn.DtxBranch;
import org.apache.qpid.server.txn.DtxRegistry;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.txn.Xid;
import org.apache.qpid.server.util.Action;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.apache.qpid.server.virtualhost.MessageStoreRecoverer;
import org.apache.qpid.server.virtualhost.QueueManagingVirtualHost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsynchronousMessageStoreRecoverer
implements MessageStoreRecoverer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsynchronousMessageStoreRecoverer.class);
    private AsynchronousRecoverer _asynchronousRecoverer;

    @Override
    public ListenableFuture<Void> recover(QueueManagingVirtualHost<?> virtualHost) {
        this._asynchronousRecoverer = new AsynchronousRecoverer(virtualHost);
        return this._asynchronousRecoverer.recover();
    }

    @Override
    public void cancel() {
        if (this._asynchronousRecoverer != null) {
            this._asynchronousRecoverer.cancel();
        }
    }

    private static class AsynchronousRecoverer {
        public static final int THREAD_POOL_SHUTDOWN_TIMEOUT = 5000;
        private final QueueManagingVirtualHost<?> _virtualHost;
        private final EventLogger _eventLogger;
        private final MessageStore _store;
        private final MessageStoreLogSubject _logSubject;
        private final long _maxMessageId;
        private final Set<Queue<?>> _recoveringQueues = new CopyOnWriteArraySet();
        private final AtomicBoolean _recoveryComplete = new AtomicBoolean();
        private final Map<Long, MessageReference<? extends ServerMessage<?>>> _recoveredMessages = new HashMap();
        private final ListeningExecutorService _queueRecoveryExecutor = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), QpidByteBuffer.createQpidByteBufferTrackingThreadFactory(Executors.defaultThreadFactory())));
        private final MessageStore.MessageStoreReader _storeReader;
        private final AtomicBoolean _continueRecovery = new AtomicBoolean(true);

        private AsynchronousRecoverer(QueueManagingVirtualHost<?> virtualHost) {
            this._virtualHost = virtualHost;
            this._eventLogger = virtualHost.getEventLogger();
            this._store = virtualHost.getMessageStore();
            this._storeReader = this._store.newMessageStoreReader();
            this._logSubject = new MessageStoreLogSubject(virtualHost.getName(), this._store.getClass().getSimpleName());
            this._maxMessageId = this._store.getNextMessageId();
            Collection<Queue> children = this._virtualHost.getChildren(Queue.class);
            this._recoveringQueues.addAll(children);
        }

        public ListenableFuture<Void> recover() {
            this.getStoreReader().visitDistributedTransactions(new DistributedTransactionVisitor());
            ArrayList<ListenableFuture> queueRecoveryFutures = new ArrayList<ListenableFuture>();
            if (this._recoveringQueues.isEmpty()) {
                return this._queueRecoveryExecutor.submit((Runnable)new RemoveOrphanedMessagesTask(), null);
            }
            for (Queue<?> queue : this._recoveringQueues) {
                ListenableFuture result = this._queueRecoveryExecutor.submit((Runnable)new QueueRecoveringTask(queue), null);
                queueRecoveryFutures.add(result);
            }
            ListenableFuture combinedFuture = Futures.allAsList(queueRecoveryFutures);
            return Futures.transform((ListenableFuture)combinedFuture, voids -> null, (Executor)MoreExecutors.directExecutor());
        }

        public QueueManagingVirtualHost<?> getVirtualHost() {
            return this._virtualHost;
        }

        public EventLogger getEventLogger() {
            return this._eventLogger;
        }

        public MessageStore.MessageStoreReader getStoreReader() {
            return this._storeReader;
        }

        public MessageStoreLogSubject getLogSubject() {
            return this._logSubject;
        }

        private boolean isRecovering(Queue<?> queue) {
            return this._recoveringQueues.contains(queue);
        }

        private void recoverQueue(Queue<?> queue) {
            MessageInstanceVisitor handler = new MessageInstanceVisitor(queue);
            this._storeReader.visitMessageInstances(queue, handler);
            if (handler.getNumberOfUnknownMessageInstances() > 0) {
                LOGGER.info("Discarded {} entry(s) associated with queue '{}' as the referenced message does not exist.", (Object)handler.getNumberOfUnknownMessageInstances(), (Object)queue.getName());
            }
            this.getEventLogger().message(this.getLogSubject(), TransactionLogMessages.RECOVERED(handler.getRecoveredCount(), queue.getName()));
            this.getEventLogger().message(this.getLogSubject(), TransactionLogMessages.RECOVERY_COMPLETE(queue.getName(), true));
            queue.completeRecovery();
            this._recoveringQueues.remove(queue);
            if (this._recoveringQueues.isEmpty() && this._recoveryComplete.compareAndSet(false, true)) {
                this.completeRecovery();
            }
        }

        private synchronized void completeRecovery() {
            for (Map.Entry<Long, MessageReference<ServerMessage<?>>> entry : this._recoveredMessages.entrySet()) {
                entry.getValue().release();
                entry.setValue(null);
            }
            final ArrayList messagesToDelete = new ArrayList();
            this.getStoreReader().visitMessages(new MessageHandler(){

                @Override
                public boolean handle(StoredMessage<?> storedMessage) {
                    long messageNumber = storedMessage.getMessageNumber();
                    if (_continueRecovery.get() && messageNumber < _maxMessageId) {
                        if (!_recoveredMessages.containsKey(messageNumber)) {
                            messagesToDelete.add(storedMessage);
                        }
                        return true;
                    }
                    return false;
                }
            });
            int unusedMessageCounter = 0;
            for (StoredMessage storedMessage : messagesToDelete) {
                if (!this._continueRecovery.get()) continue;
                LOGGER.debug("Message id '{}' is orphaned, removing", (Object)storedMessage.getMessageNumber());
                storedMessage.remove();
                ++unusedMessageCounter;
            }
            if (unusedMessageCounter > 0) {
                LOGGER.info("Discarded {} orphaned message(s).", (Object)unusedMessageCounter);
            }
            messagesToDelete.clear();
            this._recoveredMessages.clear();
            this._storeReader.close();
            this._queueRecoveryExecutor.shutdown();
        }

        private synchronized ServerMessage<?> getRecoveredMessage(long messageId) {
            StoredMessage<?> message;
            MessageReference ref = this._recoveredMessages.get(messageId);
            if (ref == null && (message = this._storeReader.getMessage(messageId)) != null) {
                Object metaData = message.getMetaData();
                MessageMetaDataType type = metaData.getType();
                ServerMessage<?> serverMessage = type.createMessage(message);
                ref = serverMessage.newReference();
                this._recoveredMessages.put(messageId, ref);
            }
            return ref == null ? null : ref.getMessage();
        }

        public void cancel() {
            this._continueRecovery.set(false);
            this._queueRecoveryExecutor.shutdown();
            try {
                boolean wasShutdown = this._queueRecoveryExecutor.awaitTermination(5000L, TimeUnit.MILLISECONDS);
                if (!wasShutdown) {
                    LOGGER.warn("Failed to gracefully shutdown queue recovery executor within permitted time period");
                    this._queueRecoveryExecutor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                this._storeReader.close();
            }
        }

        private class MessageInstanceVisitor
        implements MessageInstanceHandler {
            private final Queue<?> _queue;
            long _recoveredCount;
            private int _numberOfUnknownMessageInstances;

            private MessageInstanceVisitor(Queue<?> queue) {
                this._queue = queue;
                this._numberOfUnknownMessageInstances = 0;
            }

            @Override
            public boolean handle(MessageEnqueueRecord record) {
                long messageId = record.getMessageNumber();
                String queueName = this._queue.getName();
                if (messageId < AsynchronousRecoverer.this._maxMessageId) {
                    ServerMessage<?> message = AsynchronousRecoverer.this.getRecoveredMessage(messageId);
                    if (message != null) {
                        LOGGER.debug("Delivering message id '{}' to queue '{}'", (Object)message.getMessageNumber(), (Object)queueName);
                        this._queue.recover(message, record);
                        ++this._recoveredCount;
                    } else {
                        LOGGER.debug("Message id '{}' referenced in log as enqueued in queue '{}' is unknown, entry will be discarded", (Object)messageId, (Object)queueName);
                        Transaction txn = AsynchronousRecoverer.this._store.newTransaction();
                        txn.dequeueMessage(record);
                        txn.commitTranAsync(null);
                        ++this._numberOfUnknownMessageInstances;
                    }
                    return AsynchronousRecoverer.this._continueRecovery.get();
                }
                return false;
            }

            long getRecoveredCount() {
                return this._recoveredCount;
            }

            int getNumberOfUnknownMessageInstances() {
                return this._numberOfUnknownMessageInstances;
            }
        }

        private class RemoveOrphanedMessagesTask
        implements Runnable {
            RemoveOrphanedMessagesTask() {
            }

            @Override
            public void run() {
                String originalThreadName = Thread.currentThread().getName();
                Thread.currentThread().setName("Orphaned message removal");
                try {
                    AsynchronousRecoverer.this.completeRecovery();
                }
                finally {
                    Thread.currentThread().setName(originalThreadName);
                }
            }
        }

        private class QueueRecoveringTask
        implements Runnable {
            private final Queue<?> _queue;

            QueueRecoveringTask(Queue<?> queue) {
                this._queue = queue;
            }

            @Override
            public void run() {
                String originalThreadName = Thread.currentThread().getName();
                Thread.currentThread().setName("Queue Recoverer : " + this._queue.getName() + " (vh: " + AsynchronousRecoverer.this.getVirtualHost().getName() + ")");
                try {
                    AsynchronousRecoverer.this.recoverQueue(this._queue);
                }
                finally {
                    Thread.currentThread().setName(originalThreadName);
                }
            }
        }

        private class DistributedTransactionVisitor
        implements DistributedTransactionHandler {
            private DistributedTransactionVisitor() {
            }

            @Override
            public boolean handle(Transaction.StoredXidRecord storedXid, Transaction.EnqueueRecord[] enqueues, Transaction.DequeueRecord[] dequeues) {
                StringBuilder xidString;
                ServerMessage<?> message;
                Queue<?> queue;
                Xid id = new Xid(storedXid.getFormat(), storedXid.getGlobalId(), storedXid.getBranchId());
                DtxRegistry dtxRegistry = AsynchronousRecoverer.this.getVirtualHost().getDtxRegistry();
                DtxBranch branch = dtxRegistry.getBranch(id);
                if (branch == null) {
                    branch = new DtxBranch(storedXid, dtxRegistry);
                    dtxRegistry.registerBranch(branch);
                }
                for (Transaction.EnqueueRecord enqueueRecord : enqueues) {
                    queue = AsynchronousRecoverer.this.getVirtualHost().getAttainedQueue(enqueueRecord.getResource().getId());
                    if (queue != null) {
                        long messageId = enqueueRecord.getMessage().getMessageNumber();
                        message = AsynchronousRecoverer.this.getRecoveredMessage(messageId);
                        if (message != null) {
                            final MessageReference ref = message.newReference();
                            final MessageEnqueueRecord[] records = new MessageEnqueueRecord[1];
                            branch.enqueue(queue, message, new Action<MessageEnqueueRecord>(){

                                @Override
                                public void performAction(MessageEnqueueRecord record) {
                                    records[0] = record;
                                }
                            });
                            branch.addPostTransactionAction(new ServerTransaction.Action(){

                                @Override
                                public void postCommit() {
                                    queue.enqueue(message, null, records[0]);
                                    ref.release();
                                }

                                @Override
                                public void onRollback() {
                                    ref.release();
                                }
                            });
                            continue;
                        }
                        xidString = this.xidAsString(id);
                        AsynchronousRecoverer.this.getEventLogger().message(AsynchronousRecoverer.this.getLogSubject(), TransactionLogMessages.XA_INCOMPLETE_MESSAGE(xidString.toString(), Long.toString(messageId)));
                        continue;
                    }
                    StringBuilder xidString2 = this.xidAsString(id);
                    AsynchronousRecoverer.this.getEventLogger().message(AsynchronousRecoverer.this.getLogSubject(), TransactionLogMessages.XA_INCOMPLETE_QUEUE(xidString2.toString(), enqueueRecord.getResource().getId().toString()));
                }
                for (Transaction.DequeueRecord dequeueRecord : dequeues) {
                    queue = AsynchronousRecoverer.this.getVirtualHost().getAttainedQueue(dequeueRecord.getEnqueueRecord().getQueueId());
                    if (queue != null) {
                        long messageId;
                        if (AsynchronousRecoverer.this.isRecovering(queue)) {
                            AsynchronousRecoverer.this.recoverQueue(queue);
                        }
                        if ((message = AsynchronousRecoverer.this.getRecoveredMessage(messageId = dequeueRecord.getEnqueueRecord().getMessageNumber())) != null) {
                            final QueueEntry entry = queue.getMessageOnTheQueue(messageId);
                            if (entry.acquire()) {
                                branch.dequeue(entry.getEnqueueRecord());
                                branch.addPostTransactionAction(new ServerTransaction.Action(){

                                    @Override
                                    public void postCommit() {
                                        entry.delete();
                                    }

                                    @Override
                                    public void onRollback() {
                                        entry.release();
                                    }
                                });
                                continue;
                            }
                            throw new ServerScopedRuntimeException("Distributed transaction dequeue handler failed to acquire " + entry + " during recovery of queue " + queue);
                        }
                        xidString = this.xidAsString(id);
                        AsynchronousRecoverer.this.getEventLogger().message(AsynchronousRecoverer.this.getLogSubject(), TransactionLogMessages.XA_INCOMPLETE_MESSAGE(xidString.toString(), Long.toString(messageId)));
                        continue;
                    }
                    StringBuilder xidString3 = this.xidAsString(id);
                    AsynchronousRecoverer.this.getEventLogger().message(AsynchronousRecoverer.this.getLogSubject(), TransactionLogMessages.XA_INCOMPLETE_QUEUE(xidString3.toString(), dequeueRecord.getEnqueueRecord().getQueueId().toString()));
                }
                branch.setState(DtxBranch.State.PREPARED);
                branch.prePrepareTransaction();
                return AsynchronousRecoverer.this._continueRecovery.get();
            }

            private StringBuilder xidAsString(Xid id) {
                return new StringBuilder("(").append(id.getFormat()).append(',').append(Functions.str(id.getGlobalId())).append(',').append(Functions.str(id.getBranchId())).append(')');
            }
        }
    }
}

