/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.server.logging.Outcome;
import org.apache.qpid.server.logging.messages.AuthenticationProviderMessages;
import org.apache.qpid.server.logging.messages.UserMessages;
import org.apache.qpid.server.model.AbstractConfiguredObject;
import org.apache.qpid.server.model.Container;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.User;
import org.apache.qpid.server.security.auth.manager.ConfigModelPasswordManagingAuthenticationProvider;

@ManagedObject(category=false, type="managed")
class ManagedUser
extends AbstractConfiguredObject<ManagedUser>
implements User<ManagedUser> {
    public static final String MANAGED_USER_TYPE = "managed";
    private final ConfigModelPasswordManagingAuthenticationProvider<?> _authenticationManager;
    @ManagedAttributeField
    private String _password;

    @ManagedObjectFactoryConstructor
    ManagedUser(Map<String, Object> attributes, ConfigModelPasswordManagingAuthenticationProvider<?> parent) {
        super(parent, attributes);
        this._authenticationManager = parent;
        this.setState(State.ACTIVE);
    }

    @Override
    protected void onOpen() {
        super.onOpen();
        this._authenticationManager.getUserMap().put(this.getName(), this);
    }

    @Override
    public void onValidate() {
        super.onValidate();
        this._authenticationManager.validateUser(this);
        if (!this.isDurable()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " must be durable");
        }
    }

    @Override
    protected ListenableFuture<Void> onDelete() {
        this._authenticationManager.getUserMap().remove(this.getName());
        return super.onDelete();
    }

    @Override
    protected void changeAttributes(Map<String, Object> attributes) {
        String desiredPassword;
        String storedPassword;
        if (attributes.containsKey("password") && !(storedPassword = this._authenticationManager.createStoredPassword(desiredPassword = (String)attributes.get("password"))).equals(this.getActualAttributes().get("password"))) {
            attributes = new HashMap<String, Object>(attributes);
            attributes.put("password", storedPassword);
        }
        super.changeAttributes(attributes);
    }

    @Override
    public String getPassword() {
        return this._password;
    }

    @Override
    public void setPassword(String password) {
        this.setAttributes(Collections.singletonMap("password", password));
    }

    @Override
    protected void logOperation(String operation) {
        ((Container)this._authenticationManager.getParent()).getEventLogger().message(AuthenticationProviderMessages.OPERATION(operation));
    }

    @Override
    protected void logCreated(Map<String, Object> attributes, Outcome outcome) {
        ((Container)this._authenticationManager.getParent()).getEventLogger().message(UserMessages.CREATE(this.getName(), outcome.name(), String.valueOf(this.getActualAttributes())));
    }

    @Override
    protected void logDeleted(Outcome outcome) {
        ((Container)this._authenticationManager.getParent()).getEventLogger().message(UserMessages.DELETE(this.getName(), outcome.name()));
    }

    @Override
    protected void logUpdated(Map<String, Object> attributes, Outcome outcome) {
        ((Container)this._authenticationManager.getParent()).getEventLogger().message(UserMessages.UPDATE(this.getName(), outcome.name(), String.valueOf(this.getActualAttributes())));
    }
}

