/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import com.google.common.util.concurrent.ListenableFuture;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.DerivedAttribute;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedStatistic;
import org.apache.qpid.server.model.StatisticType;
import org.apache.qpid.server.model.StatisticUnit;

@ManagedObject(creatable=false, amqpName="org.apache.qpid.Producer")
public interface Producer<X extends Producer<X>>
extends ConfiguredObject<X> {
    public void registerMessageDelivered(long var1);

    @DerivedAttribute(description="Session ID")
    public String getSessionId();

    @DerivedAttribute(description="Session name")
    public String getSessionName();

    @DerivedAttribute(description="Connection principal")
    public String getPrincipal();

    @DerivedAttribute(description="Connection remote address")
    public String getRemoteAddress();

    @DerivedAttribute(description="Destination name")
    public String getDestination();

    @DerivedAttribute(description="Destination type (exchange or queue)")
    public DestinationType getDestinationType();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.MESSAGES)
    public int getMessagesOut();

    @ManagedStatistic(statisticType=StatisticType.POINT_IN_TIME, units=StatisticUnit.BYTES)
    public long getBytesOut();

    public ListenableFuture<Void> deleteNoChecks();

    public static enum DestinationType {
        EXCHANGE,
        QUEUE;

    }
}

