/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.messages;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.qpid.server.logging.LogMessage;
import org.slf4j.LoggerFactory;

public class BindingMessages {
    private static final ResourceBundle MESSAGES;
    private static final Locale CURRENT_LOCALE;
    public static final String BINDING_LOG_HIERARCHY = "qpid.message.binding";
    public static final String CREATED_LOG_HIERARCHY = "qpid.message.binding.created";
    public static final String DELETED_LOG_HIERARCHY = "qpid.message.binding.deleted";
    public static final String OPERATION_LOG_HIERARCHY = "qpid.message.binding.operation";

    public static LogMessage CREATED(String param1) {
        String rawMessage = MESSAGES.getString("CREATED");
        Object[] messageArguments = new Object[]{param1};
        MessageFormat formatter = new MessageFormat(rawMessage, CURRENT_LOCALE);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return BindingMessages.CREATED_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage DELETED(String param1) {
        String rawMessage = MESSAGES.getString("DELETED");
        Object[] messageArguments = new Object[]{param1};
        MessageFormat formatter = new MessageFormat(rawMessage, CURRENT_LOCALE);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return BindingMessages.DELETED_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    public static LogMessage OPERATION(String param1) {
        String rawMessage = MESSAGES.getString("OPERATION");
        Object[] messageArguments = new Object[]{param1};
        MessageFormat formatter = new MessageFormat(rawMessage, CURRENT_LOCALE);
        final String message = formatter.format(messageArguments);
        return new LogMessage(){

            public String toString() {
                return message;
            }

            @Override
            public String getLogHierarchy() {
                return BindingMessages.OPERATION_LOG_HIERARCHY;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogMessage that = (LogMessage)o;
                return this.getLogHierarchy().equals(that.getLogHierarchy()) && this.toString().equals(that.toString());
            }

            public int hashCode() {
                int result = this.toString().hashCode();
                result = 31 * result + this.getLogHierarchy().hashCode();
                return result;
            }
        };
    }

    private BindingMessages() {
    }

    static {
        Locale locale = Locale.US;
        String localeSetting = System.getProperty("qpid.broker_locale");
        if (localeSetting != null) {
            String[] localeParts = localeSetting.split("_");
            String language = localeParts.length > 0 ? localeParts[0] : "";
            String country = localeParts.length > 1 ? localeParts[1] : "";
            String variant = "";
            if (localeParts.length > 2) {
                variant = localeSetting.substring(language.length() + 1 + country.length() + 1);
            }
            locale = new Locale(language, country, variant);
        }
        CURRENT_LOCALE = locale;
        LoggerFactory.getLogger((String)BINDING_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)CREATED_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)DELETED_LOG_HIERARCHY);
        LoggerFactory.getLogger((String)OPERATION_LOG_HIERARCHY);
        MESSAGES = ResourceBundle.getBundle("org.apache.qpid.server.logging.messages.Binding_logmessages", CURRENT_LOCALE);
    }
}

