/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.FixedEightWriter;
import org.apache.qpid.server.protocol.v1_0.codec.FixedOneWriter;
import org.apache.qpid.server.protocol.v1_0.codec.ValueWriter;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedLong;

public class UnsignedLongWriter {
    private static final byte EIGHT_BYTE_FORMAT_CODE = -128;
    private static final byte ONE_BYTE_FORMAT_CODE = 83;
    private static final byte ZERO_BYTE_FORMAT_CODE = 68;
    private static final ValueWriter<UnsignedLong> ZERO_BYTE_WRITER = new ValueWriter<UnsignedLong>(){

        @Override
        public int getEncodedSize() {
            return 1;
        }

        @Override
        public void writeToBuffer(QpidByteBuffer buffer) {
            buffer.put((byte)68);
        }
    };
    private static final ValueWriter.Factory<UnsignedLong> FACTORY = new ValueWriter.Factory<UnsignedLong>(){

        @Override
        public ValueWriter<UnsignedLong> newInstance(ValueWriter.Registry registry, UnsignedLong object) {
            if (object.equals(UnsignedLong.ZERO)) {
                return ZERO_BYTE_WRITER;
            }
            if ((object.longValue() & 0xFFL) == object.longValue()) {
                return new UnsignedLongFixedOneWriter(object);
            }
            return new UnsignedLongFixedEightWriter(object);
        }
    };

    public static void register(ValueWriter.Registry registry) {
        registry.register(UnsignedLong.class, FACTORY);
    }

    public static ValueWriter<UnsignedLong> getWriter(byte value) {
        return new UnsignedLongFixedOneWriter(value);
    }

    public static ValueWriter<UnsignedLong> getWriter(long value) {
        return new UnsignedLongFixedEightWriter(value);
    }

    private static class UnsignedLongFixedEightWriter
    extends FixedEightWriter<UnsignedLong> {
        public UnsignedLongFixedEightWriter(UnsignedLong object) {
            super(object.longValue());
        }

        public UnsignedLongFixedEightWriter(long value) {
            super(value);
        }

        @Override
        byte getFormatCode() {
            return -128;
        }
    }

    private static class UnsignedLongFixedOneWriter
    extends FixedOneWriter<UnsignedLong> {
        UnsignedLongFixedOneWriter(UnsignedLong value) {
            super(value.byteValue());
        }

        UnsignedLongFixedOneWriter(byte value) {
            super(value);
        }

        @Override
        protected byte getFormatCode() {
            return 83;
        }
    }
}

