/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class UpgraderHelper {
    public static final Map<String, String> MODEL9_MAPPING_FOR_RENAME_TO_ALLOW_DENY_CONTEXT_VARIABLES = new HashMap<String, String>();

    public static Map<String, String> renameContextVariables(Map<String, String> context, Map<String, String> oldToNewNameMapping) {
        HashMap<String, String> newContext = new HashMap<String, String>(context);
        oldToNewNameMapping.forEach((oldName, newName) -> {
            if (newContext.containsKey(oldName)) {
                String value = (String)newContext.remove(oldName);
                newContext.put((String)newName, value);
            }
        });
        return newContext;
    }

    public static Map<String, String> reverse(Map<String, String> map) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }

    static {
        MODEL9_MAPPING_FOR_RENAME_TO_ALLOW_DENY_CONTEXT_VARIABLES.put("qpid.security.tls.protocolWhiteList", "qpid.security.tls.protocolAllowList");
        MODEL9_MAPPING_FOR_RENAME_TO_ALLOW_DENY_CONTEXT_VARIABLES.put("qpid.security.tls.protocolBlackList", "qpid.security.tls.protocolDenyList");
        MODEL9_MAPPING_FOR_RENAME_TO_ALLOW_DENY_CONTEXT_VARIABLES.put("qpid.security.tls.cipherSuiteWhiteList", "qpid.security.tls.cipherSuiteAllowList");
        MODEL9_MAPPING_FOR_RENAME_TO_ALLOW_DENY_CONTEXT_VARIABLES.put("qpid.security.tls.cipherSuiteBlackList", "qpid.security.tls.cipherSuiteDenyList");
    }
}

