/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange.topic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.qpid.server.exchange.topic.TopicMatcherDFAState;
import org.apache.qpid.server.exchange.topic.TopicMatcherResult;
import org.apache.qpid.server.exchange.topic.TopicWord;
import org.apache.qpid.server.exchange.topic.TopicWordDictionary;

public class TopicParser {
    private static final String TOPIC_DELIMITER = "\\.";
    private final TopicWordDictionary _dictionary = new TopicWordDictionary();
    private final AtomicReference<TopicMatcherDFAState> _stateMachine = new AtomicReference();
    private static final Position ERROR_POSITION = new Position(Integer.MAX_VALUE, null, true, false);

    public void addBinding(String bindingKey, TopicMatcherResult result) {
        TopicMatcherDFAState newStateMachine;
        TopicMatcherDFAState startingStateMachine;
        while (!this._stateMachine.compareAndSet(startingStateMachine, newStateMachine = (startingStateMachine = this._stateMachine.get()) == null ? this.createStateMachine(bindingKey, result) : startingStateMachine.mergeStateMachines(this.createStateMachine(bindingKey, result)))) {
        }
    }

    public Collection<TopicMatcherResult> parse(String routingKey) {
        TopicMatcherDFAState stateMachine = this._stateMachine.get();
        if (stateMachine == null) {
            return Collections.emptySet();
        }
        return stateMachine.parse(this._dictionary, routingKey);
    }

    private TopicMatcherDFAState createStateMachine(String bindingKey, TopicMatcherResult result) {
        int i;
        int lastWord;
        List<TopicWord> wordList = this.createTopicWordList(bindingKey);
        int wildCards = 0;
        for (TopicWord word : wordList) {
            if (word != TopicWord.WILDCARD_WORD) continue;
            ++wildCards;
        }
        if (wildCards == 0) {
            TopicMatcherDFAState[] states = new TopicMatcherDFAState[wordList.size() + 1];
            states[states.length - 1] = new TopicMatcherDFAState(Collections.emptyMap(), Collections.singleton(result));
            for (int i2 = states.length - 2; i2 >= 0; --i2) {
                states[i2] = new TopicMatcherDFAState(Collections.singletonMap(wordList.get(i2), states[i2 + 1]), Collections.emptySet());
            }
            return states[0];
        }
        if (wildCards == wordList.size()) {
            HashMap<TopicWord, TopicMatcherDFAState> stateMap = new HashMap<TopicWord, TopicMatcherDFAState>();
            TopicMatcherDFAState state = new TopicMatcherDFAState(stateMap, Collections.singleton(result));
            stateMap.put(TopicWord.ANY_WORD, state);
            return state;
        }
        int positionCount = wordList.size() - wildCards;
        Position[] positions = new Position[positionCount + 1];
        if (wordList.get(wordList.size() - 1) == TopicWord.WILDCARD_WORD) {
            lastWord = wordList.size() - 1;
            positions[positionCount] = new Position(positionCount, TopicWord.ANY_WORD, true, true);
        } else {
            lastWord = wordList.size();
            positions[positionCount] = new Position(positionCount, TopicWord.ANY_WORD, false, true);
        }
        int pos = 0;
        int wordPos = 0;
        while (wordPos < lastWord) {
            TopicWord word;
            if ((word = wordList.get(wordPos++)) == TopicWord.WILDCARD_WORD) {
                int nextWordPos = wordPos++;
                word = wordList.get(nextWordPos);
                positions[pos] = new Position(pos++, word, true, false);
                continue;
            }
            positions[pos] = new Position(pos++, word, false, false);
        }
        for (int p = 0; p < positionCount; ++p) {
            int n;
            boolean followedByWildcards = true;
            for (n = p; followedByWildcards && n < positionCount + 1 && !positions[n].isSelfTransition(); ++n) {
                if (positions[n].getWord() == TopicWord.ANY_WORD) continue;
                followedByWildcards = false;
            }
            positions[p].setFollowedByAnyLoop(followedByWildcards && n != positionCount + 1);
        }
        HashMap<Set<Position>, SimpleState> stateMap = new HashMap<Set<Position>, SimpleState>();
        SimpleState state = new SimpleState();
        state._positions = Collections.singleton(positions[0]);
        stateMap.put(state._positions, state);
        this.calculateNextStates(state, stateMap, positions);
        SimpleState[] simpleStates = stateMap.values().toArray(new SimpleState[stateMap.size()]);
        HashMap[] dfaStateMaps = new HashMap[simpleStates.length];
        HashMap<SimpleState, TopicMatcherDFAState> simple2DFAMap = new HashMap<SimpleState, TopicMatcherDFAState>();
        for (i = 0; i < simpleStates.length; ++i) {
            boolean endState = false;
            for (Position position : simpleStates[i]._positions) {
                if (!position.isEndState()) continue;
                endState = true;
                break;
            }
            Set<TopicMatcherResult> results = endState ? Collections.singleton(result) : Collections.emptySet();
            dfaStateMaps[i] = new HashMap();
            simple2DFAMap.put(simpleStates[i], new TopicMatcherDFAState(dfaStateMaps[i], results));
        }
        for (i = 0; i < simpleStates.length; ++i) {
            SimpleState simpleState = simpleStates[i];
            Map<TopicWord, SimpleState> nextSimpleStateMap = simpleState._nextState;
            for (Map.Entry entry : nextSimpleStateMap.entrySet()) {
                dfaStateMaps[i].put((TopicWord)entry.getKey(), (TopicMatcherDFAState)simple2DFAMap.get(entry.getValue()));
            }
        }
        return (TopicMatcherDFAState)simple2DFAMap.get(state);
    }

    /*
     * WARNING - void declaration
     */
    private void calculateNextStates(SimpleState state, Map<Set<Position>, SimpleState> stateMap, Position[] positions) {
        HashMap transitions = new HashMap();
        for (Position position : state._positions) {
            int n;
            if (position.isSelfTransition()) {
                void var7_14;
                Set set = (Set)transitions.get(TopicWord.ANY_WORD);
                if (set == null) {
                    HashSet hashSet = new HashSet();
                    transitions.put(TopicWord.ANY_WORD, hashSet);
                }
                var7_14.add(position);
            }
            Position nextPosition = (n = position.getPosition() + 1) == positions.length ? ERROR_POSITION : positions[n];
            HashSet<Position> dest = (HashSet<Position>)transitions.get(position.getWord());
            if (dest == null) {
                dest = new HashSet<Position>();
                transitions.put(position.getWord(), dest);
            }
            dest.add(nextPosition);
        }
        Set anyWordTransitions = (Set)transitions.get(TopicWord.ANY_WORD);
        if (anyWordTransitions != null) {
            for (Set set : transitions.values()) {
                set.addAll(anyWordTransitions);
            }
        }
        state._nextState = new HashMap<TopicWord, SimpleState>();
        for (Map.Entry entry : transitions.entrySet()) {
            if (((Set)entry.getValue()).size() > 1) {
                ((Set)entry.getValue()).remove(ERROR_POSITION);
            }
            Object loopingTerminal = null;
            for (Object destPos : (Set)entry.getValue()) {
                if (!((Position)destPos).isSelfTransition() || !((Position)destPos).isEndState()) continue;
                loopingTerminal = destPos;
                break;
            }
            if (loopingTerminal != null) {
                entry.setValue(Collections.singleton(loopingTerminal));
            } else {
                Object destPos;
                Position anyLoop = null;
                destPos = ((Set)entry.getValue()).iterator();
                while (destPos.hasNext()) {
                    Position destPos2 = (Position)destPos.next();
                    if (!destPos2.isFollowedByAnyLoop() || anyLoop != null && anyLoop.getPosition() >= destPos2.getPosition()) continue;
                    anyLoop = destPos2;
                }
                if (anyLoop != null) {
                    ArrayList<Position> removals = new ArrayList<Position>();
                    for (Position destPos3 : (Set)entry.getValue()) {
                        if (destPos3.getPosition() >= anyLoop.getPosition()) continue;
                        removals.add(destPos3);
                    }
                    ((Set)entry.getValue()).removeAll(removals);
                }
            }
            SimpleState stateForEntry = stateMap.get(entry.getValue());
            if (stateForEntry == null) {
                stateForEntry = new SimpleState();
                stateForEntry._positions = (Set)entry.getValue();
                stateMap.put((Set)entry.getValue(), stateForEntry);
                this.calculateNextStates(stateForEntry, stateMap, positions);
            }
            state._nextState.put((TopicWord)entry.getKey(), stateForEntry);
        }
        SimpleState simpleState = state._nextState.get(TopicWord.ANY_WORD);
        if (simpleState != null) {
            ArrayList<TopicWord> arrayList = new ArrayList<TopicWord>();
            for (Map.Entry<TopicWord, SimpleState> entry : state._nextState.entrySet()) {
                if (entry.getValue() != simpleState || entry.getKey() == TopicWord.ANY_WORD) continue;
                arrayList.add(entry.getKey());
            }
            for (TopicWord removeKey : arrayList) {
                state._nextState.remove(removeKey);
            }
        }
    }

    private List<TopicWord> createTopicWordList(String bindingKey) {
        String[] tokens = bindingKey.split(TOPIC_DELIMITER);
        TopicWord previousWord = null;
        ArrayList<TopicWord> wordList = new ArrayList<TopicWord>();
        for (String token : tokens) {
            TopicWord nextWord = this._dictionary.getOrCreateWord(token);
            if (previousWord == TopicWord.WILDCARD_WORD) {
                if (nextWord == TopicWord.WILDCARD_WORD) continue;
                if (nextWord == TopicWord.ANY_WORD) {
                    wordList.set(wordList.size() - 1, TopicWord.ANY_WORD);
                    nextWord = TopicWord.WILDCARD_WORD;
                }
            }
            wordList.add(nextWord);
            previousWord = nextWord;
        }
        return wordList;
    }

    private static class SimpleState {
        private Set<Position> _positions;
        private Map<TopicWord, SimpleState> _nextState;

        private SimpleState() {
        }
    }

    private static class Position {
        private final TopicWord _word;
        private final boolean _selfTransition;
        private final int _position;
        private final boolean _endState;
        private boolean _followedByAnyLoop;

        private Position(int position, TopicWord word, boolean selfTransition, boolean endState) {
            this._position = position;
            this._word = word;
            this._selfTransition = selfTransition;
            this._endState = endState;
        }

        private TopicWord getWord() {
            return this._word;
        }

        private boolean isSelfTransition() {
            return this._selfTransition;
        }

        private int getPosition() {
            return this._position;
        }

        private boolean isEndState() {
            return this._endState;
        }

        private boolean isFollowedByAnyLoop() {
            return this._followedByAnyLoop;
        }

        private void setFollowedByAnyLoop(boolean followedByAnyLoop) {
            this._followedByAnyLoop = followedByAnyLoop;
        }
    }
}

