/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.servlet.rest;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.qpid.server.management.plugin.RequestType;

public class RequestInfo {
    private final RequestType _type;
    private final List<String> _modelParts;
    private final boolean _hierarchySatisfied;
    private final String _operationName;
    private final List<String> _preferencesParts;
    private final Map<String, List<String>> _queryParameters;
    private final boolean _hasWildcard;

    public static RequestInfo createModelRequestInfo(List<String> modelParts, Map<String, List<String>> queryParameters, boolean hierarchySatisfied) {
        return new RequestInfo(RequestType.MODEL_OBJECT, modelParts, null, Collections.emptyList(), queryParameters, hierarchySatisfied);
    }

    public static RequestInfo createOperationRequestInfo(List<String> modelParts, String operationName, Map<String, List<String>> queryParameters) {
        return new RequestInfo(RequestType.OPERATION, modelParts, operationName, Collections.emptyList(), queryParameters, true);
    }

    public static RequestInfo createPreferencesRequestInfo(List<String> modelParts, List<String> preferencesParts) {
        return new RequestInfo(RequestType.USER_PREFERENCES, modelParts, null, preferencesParts, Collections.emptyMap(), true);
    }

    public static RequestInfo createPreferencesRequestInfo(List<String> modelParts, List<String> preferencesParts, Map<String, List<String>> queryParameters) {
        return new RequestInfo(RequestType.USER_PREFERENCES, modelParts, null, preferencesParts, queryParameters, true);
    }

    public static RequestInfo createVisiblePreferencesRequestInfo(List<String> modelParts, List<String> preferencesParts, Map<String, List<String>> queryParameters) {
        return new RequestInfo(RequestType.VISIBLE_PREFERENCES, modelParts, null, preferencesParts, queryParameters, true);
    }

    private RequestInfo(RequestType type, List<String> modelParts, String operationName, List<String> preferencesParts, Map<String, List<String>> queryParameters, boolean hierarchySatisfied) {
        this._type = type;
        this._operationName = operationName;
        this._modelParts = ImmutableList.copyOf(modelParts);
        this._hierarchySatisfied = hierarchySatisfied;
        this._hasWildcard = this._modelParts.contains("*");
        this._preferencesParts = ImmutableList.copyOf(preferencesParts);
        this._queryParameters = ImmutableMap.copyOf(queryParameters);
    }

    public RequestType getType() {
        return this._type;
    }

    public List<String> getModelParts() {
        return this._modelParts;
    }

    public String getOperationName() {
        if (this._type != RequestType.OPERATION) {
            throw new IllegalStateException("Must not call getOperationName on non-Operation RequestInfo");
        }
        return this._operationName;
    }

    public List<String> getPreferencesParts() {
        return this._preferencesParts;
    }

    public Map<String, List<String>> getQueryParameters() {
        return this._queryParameters;
    }

    public boolean hasWildcard() {
        return this._hasWildcard;
    }

    public boolean isSingletonRequest() {
        return this._hierarchySatisfied && !this._hasWildcard;
    }
}

