/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.DerivedAttribute;
import org.apache.qpid.server.model.ManagedAttribute;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.model.Plugin;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.query.engine.evaluator.settings.DefaultQuerySettings;

public interface HttpManagementConfiguration<X extends HttpManagementConfiguration<X>>
extends Plugin<X> {
    public static final String HTTP_MANAGEMENT_COMPRESS_RESPONSES = "httpManagement.compressResponses";
    @ManagedContextDefault(name="httpManagement.compressResponses")
    public static final boolean DEFAULT_COMPRESS_RESPONSES = true;
    public static final String MAX_HTTP_FILE_UPLOAD_SIZE_CONTEXT_NAME = "maxHttpFileUploadSize";
    @ManagedContextDefault(name="maxHttpFileUploadSize")
    public static final long DEFAULT_MAX_UPLOAD_SIZE = 102400L;
    public static final String PREFERENCE_OPERTAION_TIMEOUT_CONTEXT_NAME = "qpid.httpManagement.preferenceOperationTimeout";
    @ManagedContextDefault(name="qpid.httpManagement.preferenceOperationTimeout")
    public static final long DEFAULT_PREFERENCE_OPERATION_TIMEOUT = 10000L;
    public static final String SASL_EXCHANGE_EXPIRY_CONTEXT_NAME = "qpid.httpManagement.saslExchangeExpiry";
    @ManagedContextDefault(name="qpid.httpManagement.saslExchangeExpiry")
    public static final long DEFAULT_SASL_EXCHANGE_EXPIRY = 60000L;
    public static final String DISABLE_UI_CONTEXT_NAME = "qpid.httpManagement.disableUserInterface";
    @ManagedContextDefault(name="qpid.httpManagement.disableUserInterface")
    public static final boolean DEFAULT_DISABLE_UI = false;
    public static final String HTTP_MANAGEMENT_ENABLE_CONTENT_AUTHENTICATION = "qpid.httpManagement.enableMetricContentAuthentication";
    @ManagedContextDefault(name="qpid.httpManagement.enableMetricContentAuthentication")
    public static final boolean DEFAULT_HTTP_MANAGEMENT_ENABLE_CONTENT_AUTHENTICATION = false;
    public static final String QUERY_ENGINE_CACHE_SIZE = "qpid.port.http.query.engine.cacheSize";
    @ManagedContextDefault(name="qpid.port.http.query.engine.cacheSize", description="Broker query engine cache size.")
    public static final int DEFAULT_QUERY_ENGINE_CACHE_SIZE = DefaultQuerySettings.MAX_QUERY_CACHE_SIZE;
    public static final String QUERY_ENGINE_MAX_QUERY_DEPTH = "qpid.port.http.query.engine.maxQueryDepth";
    @ManagedContextDefault(name="qpid.port.http.query.engine.maxQueryDepth", description="Broker query engine max query depth.")
    public static final int DEFAULT_QUERY_ENGINE_MAX_QUERY_DEPTH = DefaultQuerySettings.MAX_QUERY_DEPTH;
    public static final String QUERY_ENGINE_TIMEZONE_ID = "qpid.port.http.query.engine.timezoneId";
    @ManagedContextDefault(name="qpid.port.http.query.engine.timezoneId", description="Broker query engine time zone id.")
    public static final String DEFAULT_QUERY_ENGINE_TIMEZONE_ID = DefaultQuerySettings.ZONE_ID;

    @ManagedAttribute(defaultValue="true")
    public boolean isHttpsSaslAuthenticationEnabled();

    @ManagedAttribute(defaultValue="true")
    public boolean isHttpSaslAuthenticationEnabled();

    @ManagedAttribute(defaultValue="true")
    public boolean isHttpsBasicAuthenticationEnabled();

    @ManagedAttribute(defaultValue="false")
    public boolean isHttpBasicAuthenticationEnabled();

    @ManagedAttribute(defaultValue="600", description="The maximum time interval, in seconds, that Web Management will keep the session open between client accesses.")
    public int getSessionTimeout();

    @ManagedAttribute(defaultValue="")
    public String getCorsAllowOrigins();

    @ManagedAttribute(defaultValue="[\"HEAD\",\"GET\",\"POST\"]", validValues={"org.apache.qpid.server.management.plugin.HttpManagement#getAllAvailableCorsMethodCombinations()"})
    public Set<String> getCorsAllowMethods();

    @ManagedAttribute(defaultValue="Content-Type,Accept,Origin,X-Requested-With,X-Range")
    public String getCorsAllowHeaders();

    @ManagedAttribute(defaultValue="[\"Access-Control-Allow-Credentials\", \"Access-Control-Allow-Origin\", \"Cache-Control\", \"Content-Encoding\", \"Content-Disposition\", \"Content-Length\", \"Content-Type\", \"Date\", \"Location\", \"Expires\", \"Negotiate\", \"Pragma\", \"Set-Cookie\", \"Transfer-Encoding\", \"Vary\", \"WWW-Authenticate\"]")
    public Set<String> getAllowedResponseHeaders();

    @ManagedAttribute(defaultValue="true")
    public boolean getCorsAllowCredentials();

    @ManagedAttribute(defaultValue="${httpManagement.compressResponses}")
    public boolean isCompressResponses();

    @DerivedAttribute(description="Length of time permitted for the SASL authentication exchange.")
    public long getSaslExchangeExpiry();

    public AuthenticationProvider getAuthenticationProvider(HttpServletRequest var1);

    public Port<?> getPort(HttpServletRequest var1);
}

