/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.firewall;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.qpid.server.security.access.firewall.AccessControlFirewallException;
import org.apache.qpid.server.security.access.firewall.FirewallRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostnameFirewallRule
extends FirewallRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(HostnameFirewallRule.class);
    private static final long DNS_TIMEOUT = 30000L;
    private static final ExecutorService DNS_LOOKUP = Executors.newCachedThreadPool();
    private Pattern[] _hostnamePatterns;
    private String[] _hostnames;

    public HostnameFirewallRule(String ... hostnames) {
        this._hostnames = hostnames;
        int i = 0;
        this._hostnamePatterns = new Pattern[hostnames.length];
        for (String hostname : hostnames) {
            this._hostnamePatterns[i++] = Pattern.compile(hostname);
        }
        LOGGER.debug("Created {}", (Object)this);
    }

    @Override
    protected boolean matches(InetAddress remote) {
        String hostname = this.getHostname(remote);
        if (hostname == null) {
            throw new AccessControlFirewallException("DNS lookup failed for address " + remote);
        }
        for (Pattern pattern : this._hostnamePatterns) {
            boolean hostnameMatches = pattern.matcher(hostname).matches();
            if (!hostnameMatches) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Hostname " + hostname + " matches rule " + pattern.toString());
            }
            return true;
        }
        LOGGER.debug("Hostname {} matches no configured hostname patterns", (Object)hostname);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getHostname(final InetAddress remote) throws AccessControlFirewallException {
        FutureTask<String> lookup = new FutureTask<String>(new Callable<String>(){

            @Override
            public String call() {
                return remote.getCanonicalHostName();
            }
        });
        DNS_LOOKUP.execute(lookup);
        try {
            String string = lookup.get(30000L, TimeUnit.MILLISECONDS);
            return string;
        }
        catch (Exception e) {
            LOGGER.warn("Unable to look up hostname from address " + remote, (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            lookup.cancel(true);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostnameFirewallRule that = (HostnameFirewallRule)o;
        return Arrays.equals(this._hostnames, that._hostnames);
    }

    public int hashCode() {
        return this._hostnames != null ? Arrays.hashCode(this._hostnames) : 0;
    }

    public String toString() {
        return "HostnameFirewallRule[hostnames=" + Arrays.toString(this._hostnames) + ']';
    }
}

