/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.qpid.server.security.access.config.AclRulePredicates;
import org.apache.qpid.server.security.access.config.Action;
import org.apache.qpid.server.security.access.config.DynamicRule;
import org.apache.qpid.server.security.access.config.LegacyOperation;
import org.apache.qpid.server.security.access.config.ObjectProperties;
import org.apache.qpid.server.security.access.config.ObjectType;

public class AclAction {
    private Action _action;
    private AclRulePredicates _predicates;

    public AclAction(LegacyOperation operation, ObjectType object, AclRulePredicates predicates) {
        ObjectProperties properties = predicates == null ? ObjectProperties.EMPTY : predicates.getObjectProperties();
        this._action = new Action(operation, object, properties);
        this._predicates = predicates;
    }

    public AclAction(LegacyOperation operation) {
        this._action = new Action(operation);
    }

    public AclAction(LegacyOperation operation, ObjectType object, ObjectProperties properties) {
        this._action = new Action(operation, object, properties);
    }

    public DynamicRule getDynamicRule() {
        return this._predicates == null ? null : this._predicates.getDynamicRule();
    }

    public Action getAction() {
        return this._action;
    }

    public boolean isAllowed() {
        return this._action.isSupported();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AclAction aclAction = (AclAction)o;
        if (this.getAction() != null ? !this.getAction().equals(aclAction.getAction()) : aclAction.getAction() != null) {
            return false;
        }
        return Objects.equals(this._predicates, aclAction._predicates);
    }

    public int hashCode() {
        int result = this.getAction() != null ? this.getAction().hashCode() : 0;
        result = 31 * result + (this._predicates != null ? this._predicates.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "AclAction[action=" + this._action + ", predicates=" + this._predicates + ']';
    }

    public Map<ObjectProperties.Property, String> getAttributes() {
        return this._predicates == null ? Collections.emptyMap() : this._predicates.getParsedProperties();
    }
}

