/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.store;

import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.ValueHandler;
import org.apache.qpid.server.protocol.v1_0.codec.ValueWriter;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.codec.AMQPDescribedTypeRegistry;
import org.apache.qpid.server.store.StoreException;

public class LinkStoreUtils {
    private static final AMQPDescribedTypeRegistry DESCRIBED_TYPE_REGISTRY = AMQPDescribedTypeRegistry.newInstance().registerTransportLayer().registerMessagingLayer();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object amqpBytesToObject(byte[] bytes) {
        ValueHandler valueHandler = new ValueHandler(DESCRIBED_TYPE_REGISTRY);
        try (QpidByteBuffer qpidByteBuffer = QpidByteBuffer.wrap((byte[])bytes);){
            Object object = valueHandler.parse(qpidByteBuffer);
            return object;
        }
        catch (AmqpErrorException e) {
            throw new StoreException("Unexpected serialized data", (Throwable)e);
        }
    }

    public static byte[] objectToAmqpBytes(Object object) {
        ValueWriter<Object> valueWriter = DESCRIBED_TYPE_REGISTRY.getValueWriter(object);
        int encodedSize = valueWriter.getEncodedSize();
        try (QpidByteBuffer qpidByteBuffer = QpidByteBuffer.allocate((int)encodedSize);){
            valueWriter.writeToBuffer(qpidByteBuffer);
            byte[] byArray = qpidByteBuffer.array();
            return byArray;
        }
    }
}

