/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.qpid.server.model.NamedAddressSpace;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.protocol.v1_0.LinkDefinition;
import org.apache.qpid.server.protocol.v1_0.LinkImpl;
import org.apache.qpid.server.protocol.v1_0.LinkKey;
import org.apache.qpid.server.protocol.v1_0.LinkRegistry;
import org.apache.qpid.server.protocol.v1_0.Link_1_0;
import org.apache.qpid.server.protocol.v1_0.store.LinkStore;
import org.apache.qpid.server.protocol.v1_0.store.LinkStoreFactory;
import org.apache.qpid.server.protocol.v1_0.store.LinkStoreUpdaterImpl;
import org.apache.qpid.server.protocol.v1_0.type.BaseSource;
import org.apache.qpid.server.protocol.v1_0.type.BaseTarget;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Source;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Target;
import org.apache.qpid.server.protocol.v1_0.type.messaging.TerminusDurability;
import org.apache.qpid.server.protocol.v1_0.type.transport.Role;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.apache.qpid.server.virtualhost.LinkRegistryModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkRegistryImpl<S extends BaseSource, T extends BaseTarget>
implements LinkRegistry<S, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LinkRegistryImpl.class);
    private final ConcurrentMap<LinkKey, Link_1_0<S, T>> _sendingLinkRegistry = new ConcurrentHashMap<LinkKey, Link_1_0<S, T>>();
    private final ConcurrentMap<LinkKey, Link_1_0<S, T>> _receivingLinkRegistry = new ConcurrentHashMap<LinkKey, Link_1_0<S, T>>();
    private final LinkStore _linkStore;

    LinkRegistryImpl(NamedAddressSpace addressSpace) {
        LinkStoreFactory storeFactory = null;
        Iterable linkStoreFactories = new QpidServiceLoader().instancesOf(LinkStoreFactory.class);
        for (LinkStoreFactory linkStoreFactory : linkStoreFactories) {
            if (!linkStoreFactory.supports(addressSpace) || storeFactory != null && storeFactory.getPriority() >= linkStoreFactory.getPriority()) continue;
            storeFactory = linkStoreFactory;
        }
        if (storeFactory == null) {
            throw new ServerScopedRuntimeException("Cannot find suitable link store");
        }
        this._linkStore = storeFactory.create(addressSpace);
    }

    public Link_1_0<S, T> getSendingLink(String remoteContainerId, String linkName) {
        return this.getLinkFromRegistry(remoteContainerId, linkName, this._sendingLinkRegistry, Role.SENDER);
    }

    public Link_1_0<S, T> getReceivingLink(String remoteContainerId, String linkName) {
        return this.getLinkFromRegistry(remoteContainerId, linkName, this._receivingLinkRegistry, Role.RECEIVER);
    }

    @Override
    public void linkClosed(Link_1_0<S, T> link) {
        ConcurrentMap<LinkKey, Link_1_0<S, T>> linkRegistry = this.getLinkRegistry(link.getRole());
        linkRegistry.remove(new LinkKey(link));
        if (this.isDurableLink(link)) {
            this._linkStore.deleteLink(link);
        }
    }

    @Override
    public void linkChanged(Link_1_0<S, T> link) {
        this.getLinkRegistry(link.getRole()).putIfAbsent(new LinkKey(link), link);
        if (this.isDurableLink(link)) {
            this._linkStore.saveLink(link);
        }
    }

    @Override
    public TerminusDurability getHighestSupportedTerminusDurability() {
        TerminusDurability supportedTerminusDurability = this._linkStore.getHighestSupportedTerminusDurability();
        return supportedTerminusDurability == TerminusDurability.UNSETTLED_STATE ? TerminusDurability.CONFIGURATION : supportedTerminusDurability;
    }

    public Collection<Link_1_0<S, T>> findSendingLinks(Pattern containerIdPattern, Pattern linkNamePattern) {
        return this._sendingLinkRegistry.entrySet().stream().filter(e -> containerIdPattern.matcher(((LinkKey)e.getKey()).getRemoteContainerId()).matches() && linkNamePattern.matcher(((LinkKey)e.getKey()).getLinkName()).matches()).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public void visitSendingLinks(LinkRegistryModel.LinkVisitor<Link_1_0<S, T>> visitor) {
        this.visitLinks(this._sendingLinkRegistry.values(), visitor);
    }

    private void visitLinks(Collection<Link_1_0<S, T>> links, LinkRegistryModel.LinkVisitor<Link_1_0<S, T>> visitor) {
        for (Link_1_0<S, T> link : links) {
            if (visitor.visit(link)) break;
        }
    }

    public void purgeSendingLinks(Pattern containerIdPattern, Pattern linkNamePattern) {
        this.purgeLinks(this._sendingLinkRegistry, containerIdPattern, linkNamePattern);
    }

    public void purgeReceivingLinks(Pattern containerIdPattern, Pattern linkNamePattern) {
        this.purgeLinks(this._receivingLinkRegistry, containerIdPattern, linkNamePattern);
    }

    public void open() {
        Collection<LinkDefinition<Source, Target>> links = this._linkStore.openAndLoad(new LinkStoreUpdaterImpl());
        for (LinkDefinition<Source, Target> link : links) {
            ConcurrentMap<LinkKey, Link_1_0<S, T>> linkRegistry = this.getLinkRegistry(link.getRole());
            LinkDefinition<Source, Target> definition = link;
            linkRegistry.put(new LinkKey(link), new LinkImpl<Source, Target>(definition, this));
        }
    }

    public void close() {
        this._linkStore.close();
    }

    public void delete() {
        this._linkStore.delete();
    }

    private boolean isDurableLink(Link_1_0<? extends BaseSource, ? extends BaseTarget> link) {
        return link.getRole() == Role.SENDER && link.getSource() instanceof Source && ((Source)link.getSource()).getDurable() != TerminusDurability.NONE || link.getRole() == Role.RECEIVER && link.getTarget() instanceof Target && ((Target)link.getTarget()).getDurable() != TerminusDurability.NONE;
    }

    private Link_1_0<S, T> getLinkFromRegistry(String remoteContainerId, String linkName, ConcurrentMap<LinkKey, Link_1_0<S, T>> linkRegistry, Role role) {
        LinkKey linkKey = new LinkKey(remoteContainerId, linkName, role);
        LinkImpl newLink = new LinkImpl(remoteContainerId, linkName, role, this);
        LinkImpl link = linkRegistry.putIfAbsent(linkKey, newLink);
        if (link == null) {
            link = newLink;
        }
        return link;
    }

    private void purgeLinks(ConcurrentMap<LinkKey, Link_1_0<S, T>> linkRegistry, Pattern containerIdPattern, Pattern linkNamePattern) {
        linkRegistry.entrySet().stream().filter(e -> containerIdPattern.matcher(((LinkKey)e.getKey()).getRemoteContainerId()).matches() && linkNamePattern.matcher(((LinkKey)e.getKey()).getLinkName()).matches()).forEach(e -> ((Link_1_0)e.getValue()).linkClosed());
    }

    private ConcurrentMap<LinkKey, Link_1_0<S, T>> getLinkRegistry(Role role) {
        ConcurrentMap<LinkKey, Link_1_0<S, T>> linkRegistry;
        if (Role.SENDER == role) {
            linkRegistry = this._sendingLinkRegistry;
        } else if (Role.RECEIVER == role) {
            linkRegistry = this._receivingLinkRegistry;
        } else {
            throw new ServerScopedRuntimeException(String.format("Unsupported link role %s", role));
        }
        return linkRegistry;
    }

    public LinkRegistryDump dump() {
        LinkRegistryDump dump = new LinkRegistryDump();
        this.dumpRegistry(this._sendingLinkRegistry, dump);
        this.dumpRegistry(this._receivingLinkRegistry, dump);
        return dump;
    }

    private void dumpRegistry(ConcurrentMap<LinkKey, Link_1_0<S, T>> registry, LinkRegistryDump dump) {
        for (Map.Entry entry : registry.entrySet()) {
            LinkKey linkKey = (LinkKey)entry.getKey();
            LinkRegistryDump.ContainerDump containerLinks = dump._containers.computeIfAbsent(linkKey.getRemoteContainerId(), k -> new LinkRegistryDump.ContainerDump());
            LinkRegistryDump.ContainerDump.LinkDump linkDump = new LinkRegistryDump.ContainerDump.LinkDump();
            linkDump._source = String.valueOf(((Link_1_0)entry.getValue()).getSource());
            linkDump._target = String.valueOf(((Link_1_0)entry.getValue()).getTarget());
            if (linkKey.getRole().equals(Role.SENDER)) {
                containerLinks._sendingLinks.put(linkKey.getLinkName(), linkDump);
                continue;
            }
            containerLinks._receivingLinks.put(linkKey.getLinkName(), linkDump);
        }
    }

    static class LinkRegistryDump {
        private Map<String, ContainerDump> _containers = new LinkedHashMap<String, ContainerDump>();

        LinkRegistryDump() {
        }

        public Map<String, ContainerDump> getContainers() {
            return Collections.unmodifiableMap(this._containers);
        }

        static class ContainerDump {
            private Map<String, LinkDump> _sendingLinks = new LinkedHashMap<String, LinkDump>();
            private Map<String, LinkDump> _receivingLinks = new LinkedHashMap<String, LinkDump>();

            ContainerDump() {
            }

            public Map<String, LinkDump> getSendingLinks() {
                return Collections.unmodifiableMap(this._sendingLinks);
            }

            public Map<String, LinkDump> getReceivingLinks() {
                return Collections.unmodifiableMap(this._receivingLinks);
            }

            public static class LinkDump {
                private String _source;
                private String _target;

                public String getSource() {
                    return this._source;
                }

                public String getTarget() {
                    return this._target;
                }
            }
        }
    }
}

