/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v0_10.FrameSizeObserver;
import org.apache.qpid.server.protocol.v0_10.ProtocolEventSender;
import org.apache.qpid.server.protocol.v0_10.ServerEncoder;
import org.apache.qpid.server.protocol.v0_10.transport.Header;
import org.apache.qpid.server.protocol.v0_10.transport.Method;
import org.apache.qpid.server.protocol.v0_10.transport.ProtocolDelegate;
import org.apache.qpid.server.protocol.v0_10.transport.ProtocolError;
import org.apache.qpid.server.protocol.v0_10.transport.ProtocolEvent;
import org.apache.qpid.server.protocol.v0_10.transport.ProtocolHeader;
import org.apache.qpid.server.protocol.v0_10.transport.SegmentType;
import org.apache.qpid.server.protocol.v0_10.transport.Struct;
import org.apache.qpid.server.transport.ByteBufferSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServerDisassembler
implements ProtocolEventSender,
ProtocolDelegate<Void>,
FrameSizeObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerDisassembler.class);
    private final ByteBufferSender _sender;
    private int _maxPayload;
    private final Object _sendLock = new Object();
    private final ServerEncoder _encoder = new ServerEncoder();

    public ServerDisassembler(ByteBufferSender sender, int maxFrame) {
        this._sender = sender;
        if (maxFrame <= 12 || maxFrame >= 65536) {
            throw new IllegalArgumentException("maxFrame must be > HEADER_SIZE and < 64K: " + maxFrame);
        }
        this._maxPayload = maxFrame - 12;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(ProtocolEvent event) {
        Object object = this._sendLock;
        synchronized (object) {
            event.delegate(null, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Object object = this._sendLock;
        synchronized (object) {
            this._sender.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this._sendLock;
        synchronized (object) {
            this._sender.close();
        }
    }

    private void frame(byte flags, byte type, byte track, int channel, int size, QpidByteBuffer buffer) {
        try (QpidByteBuffer data = QpidByteBuffer.allocateDirect((int)12);){
            data.put(0, flags);
            data.put(1, type);
            data.putShort(2, (short)(size + 12));
            data.put(4, (byte)0);
            data.put(5, track);
            data.putShort(6, (short)channel);
            this._sender.send(data);
        }
        if (size > 0) {
            var8_8 = null;
            try (QpidByteBuffer view = buffer.view(0, size);){
                this._sender.send(view);
                buffer.position(buffer.position() + size);
            }
            catch (Throwable throwable) {
                var8_8 = throwable;
                throw throwable;
            }
        }
    }

    private void fragment(byte flags, SegmentType type, ProtocolEvent event, QpidByteBuffer buffer) {
        byte typeb = (byte)type.getValue();
        byte track = event.getEncodedTrack() == 3 ? (byte)1 : 0;
        int remaining = buffer.remaining();
        boolean first = true;
        do {
            int size = Math.min(this._maxPayload, remaining);
            remaining -= size;
            byte newflags = flags;
            if (first) {
                newflags = (byte)(newflags | 2);
                first = false;
            }
            if (remaining == 0) {
                newflags = (byte)(newflags | 1);
            }
            this.frame(newflags, typeb, track, event.getChannel(), size, buffer);
        } while (remaining != 0);
    }

    @Override
    public void init(Void v, ProtocolHeader header) {
        this._sender.send(header.toByteBuffer());
        this._sender.flush();
    }

    @Override
    public void control(Void v, Method method) {
        this.method(method, SegmentType.CONTROL);
    }

    @Override
    public void command(Void v, Method method) {
        this.method(method, SegmentType.COMMAND);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void method(Method method, SegmentType type) {
        ServerEncoder enc = this._encoder;
        enc.init();
        enc.writeUint16(method.getEncodedType());
        if (type == SegmentType.COMMAND) {
            if (method.isSync()) {
                enc.writeUint16(257);
            } else {
                enc.writeUint16(256);
            }
        }
        method.write(enc);
        int methodLimit = enc.position();
        byte flags = 8;
        boolean payload = method.hasPayload();
        if (!payload) {
            flags = (byte)(flags | 4);
        }
        int headerLimit = -1;
        if (payload) {
            Header hdr = method.getHeader();
            if (hdr != null) {
                if (hdr.getDeliveryProperties() != null) {
                    enc.writeStruct32(hdr.getDeliveryProperties());
                }
                if (hdr.getMessageProperties() != null) {
                    enc.writeStruct32(hdr.getMessageProperties());
                }
                if (hdr.getNonStandardProperties() != null) {
                    for (Struct st : hdr.getNonStandardProperties()) {
                        enc.writeStruct32(st);
                    }
                }
            }
            headerLimit = enc.position();
        }
        Object object = this._sendLock;
        synchronized (object) {
            block62: {
                try (QpidByteBuffer buf = enc.getBuffer();){
                    try (QpidByteBuffer duplicate = buf.view(0, methodLimit);){
                        this.fragment(flags, type, method, duplicate);
                    }
                    if (!payload) break block62;
                    QpidByteBuffer body = method.getBody();
                    buf.limit(headerLimit);
                    buf.position(methodLimit);
                    try (QpidByteBuffer slice = buf.slice();){
                        this.fragment(body == null ? (byte)4 : 0, SegmentType.HEADER, method, slice);
                    }
                    if (body == null) break block62;
                    var13_17 = null;
                    try (QpidByteBuffer dup = body.duplicate();){
                        this.fragment((byte)4, SegmentType.BODY, method, dup);
                    }
                    catch (Throwable throwable) {
                        var13_17 = throwable;
                        throw throwable;
                    }
                }
            }
        }
    }

    @Override
    public void error(Void v, ProtocolError error) {
        throw new IllegalArgumentException(String.valueOf(error));
    }

    @Override
    public void setMaxFrameSize(int maxFrame) {
        if (maxFrame <= 12 || maxFrame >= 65536) {
            throw new IllegalArgumentException("maxFrame must be > HEADER_SIZE and < 64K: " + maxFrame);
        }
        this._maxPayload = maxFrame - 12;
    }

    public void closed() {
        this._encoder.close();
    }
}

