/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.auth;

import java.io.IOException;
import java.security.AccessControlException;
import javax.security.auth.Subject;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.qpid.server.management.plugin.HttpManagementConfiguration;
import org.apache.qpid.server.management.plugin.HttpManagementUtil;
import org.apache.qpid.server.management.plugin.HttpRequestInteractiveAuthenticator;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.SubjectAuthenticationResult;
import org.apache.qpid.server.security.auth.manager.AnonymousAuthenticationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluggableService
public class AnonymousInteractiveAuthenticator
implements HttpRequestInteractiveAuthenticator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnonymousInteractiveAuthenticator.class);
    private static final String ANONYMOUS = "Anonymous";
    private static final HttpRequestInteractiveAuthenticator.LogoutHandler LOGOUT_HANDLER = response -> response.sendRedirect("/logout.html");

    @Override
    public HttpRequestInteractiveAuthenticator.AuthenticationHandler getAuthenticationHandler(HttpServletRequest request, HttpManagementConfiguration configuration) {
        Port<?> port = configuration.getPort(request);
        if (configuration.getAuthenticationProvider(request) instanceof AnonymousAuthenticationManager) {
            return response -> this.getLoginHandler(request, response, configuration, port);
        }
        return null;
    }

    private void getLoginHandler(HttpServletRequest request, HttpServletResponse response, HttpManagementConfiguration configuration, Port<?> port) throws ServletException, IOException {
        AnonymousAuthenticationManager authenticationProvider = (AnonymousAuthenticationManager)configuration.getAuthenticationProvider(request);
        AuthenticationResult authenticationResult = authenticationProvider.getAnonymousAuthenticationResult();
        try {
            SubjectAuthenticationResult result = port.getSubjectCreator(request.isSecure(), request.getServerName()).createResultWithGroups(authenticationResult);
            Subject original = result.getSubject();
            if (original == null) {
                throw new SecurityException("Only authenticated users can access the management interface");
            }
            Subject subject = HttpManagementUtil.createServletConnectionSubject(request, original);
            Broker broker = (Broker)authenticationProvider.getParent();
            HttpManagementUtil.assertManagementAccess(broker, subject);
            HttpManagementUtil.saveAuthorisedSubject(request, subject);
            request.getRequestDispatcher("/index.html").forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (AccessControlException e) {
            LOGGER.info("User '{}' is not authorised for management", (Object)authenticationResult.getMainPrincipal());
            response.sendError(403, "User is not authorised for management");
        }
        catch (SecurityException e) {
            LOGGER.info("Authentication failed", (Throwable)authenticationResult.getCause());
            response.sendError(401);
        }
    }

    @Override
    public HttpRequestInteractiveAuthenticator.LogoutHandler getLogoutHandler(HttpServletRequest request, HttpManagementConfiguration configuration) {
        if (configuration.getAuthenticationProvider(request) instanceof AnonymousAuthenticationManager) {
            return LOGOUT_HANDLER;
        }
        return null;
    }

    public String getType() {
        return ANONYMOUS;
    }
}

