/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhost.connection;

import java.util.Collections;
import java.util.List;
import org.apache.qpid.server.virtualhost.ConnectionPrincipalStatistics;

class ConnectionPrincipalStatisticsImpl
implements ConnectionPrincipalStatistics {
    private final int _connectionCount;
    private final List<Long> _latestConnectionCreatedTimes;

    ConnectionPrincipalStatisticsImpl(int connectionCount, List<Long> latestConnectionCreatedTimes) {
        this._connectionCount = connectionCount;
        this._latestConnectionCreatedTimes = Collections.unmodifiableList(latestConnectionCreatedTimes);
    }

    @Override
    public int getConnectionCount() {
        return this._connectionCount;
    }

    @Override
    public int getConnectionFrequency() {
        return this._latestConnectionCreatedTimes.size();
    }

    List<Long> getLatestConnectionCreatedTimes() {
        return this._latestConnectionCreatedTimes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionPrincipalStatisticsImpl that = (ConnectionPrincipalStatisticsImpl)o;
        if (this._connectionCount != that._connectionCount) {
            return false;
        }
        return this._latestConnectionCreatedTimes.equals(that._latestConnectionCreatedTimes);
    }

    public int hashCode() {
        int result = this._connectionCount;
        result = 31 * result + this._latestConnectionCreatedTimes.hashCode();
        return result;
    }
}

