/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.serializer.v1;

import java.io.IOException;
import java.util.UUID;
import org.apache.qpid.server.message.EnqueueableMessage;
import org.apache.qpid.server.store.MessageDurability;
import org.apache.qpid.server.store.MessageEnqueueRecord;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.store.Transaction;
import org.apache.qpid.server.store.TransactionLogResource;
import org.apache.qpid.server.store.serializer.v1.Deserializer;
import org.apache.qpid.server.store.serializer.v1.Record;
import org.apache.qpid.server.store.serializer.v1.RecordType;
import org.apache.qpid.server.store.serializer.v1.Serializer;

class DTXRecord
implements Record {
    private final Transaction.StoredXidRecord _xid;
    private final Transaction.EnqueueRecord[] _enqueues;
    private final Transaction.DequeueRecord[] _dequeues;

    public DTXRecord(Transaction.StoredXidRecord storedXid, Transaction.EnqueueRecord[] enqueues, Transaction.DequeueRecord[] dequeues) {
        this._xid = storedXid;
        this._enqueues = enqueues;
        this._dequeues = dequeues;
    }

    @Override
    public RecordType getType() {
        return RecordType.DTX;
    }

    public Transaction.StoredXidRecord getXid() {
        return this._xid;
    }

    public Transaction.EnqueueRecord[] getEnqueues() {
        return this._enqueues;
    }

    public Transaction.DequeueRecord[] getDequeues() {
        return this._dequeues;
    }

    @Override
    public void writeData(Serializer output) throws IOException {
        output.writeLong(this._xid.getFormat());
        output.writeInt(this._xid.getGlobalId().length);
        output.write(this._xid.getGlobalId());
        output.writeInt(this._xid.getBranchId().length);
        output.write(this._xid.getBranchId());
        output.writeInt(this._enqueues.length);
        for (Transaction.EnqueueRecord enqueueRecord : this._enqueues) {
            output.writeLong(enqueueRecord.getMessage().getMessageNumber());
            output.writeLong(enqueueRecord.getResource().getId().getMostSignificantBits());
            output.writeLong(enqueueRecord.getResource().getId().getLeastSignificantBits());
        }
        output.writeInt(this._dequeues.length);
        for (Transaction.DequeueRecord dequeueRecord : this._dequeues) {
            output.writeLong(dequeueRecord.getEnqueueRecord().getMessageNumber());
            output.writeLong(dequeueRecord.getEnqueueRecord().getQueueId().getMostSignificantBits());
            output.writeLong(dequeueRecord.getEnqueueRecord().getQueueId().getLeastSignificantBits());
        }
    }

    public static DTXRecord read(Deserializer deserializer) throws IOException {
        final long format = deserializer.readLong();
        final byte[] globalId = deserializer.readBytes(deserializer.readInt());
        final byte[] branchId = deserializer.readBytes(deserializer.readInt());
        Transaction.StoredXidRecord xid = new Transaction.StoredXidRecord(){

            @Override
            public long getFormat() {
                return format;
            }

            @Override
            public byte[] getGlobalId() {
                return globalId;
            }

            @Override
            public byte[] getBranchId() {
                return branchId;
            }
        };
        Transaction.EnqueueRecord[] enqueues = new Transaction.EnqueueRecord[deserializer.readInt()];
        for (int i = 0; i < enqueues.length; ++i) {
            enqueues[i] = new EnqueueRecordImpl(deserializer.readLong(), deserializer.readUUID());
        }
        Transaction.DequeueRecord[] dequeues = new Transaction.DequeueRecord[deserializer.readInt()];
        for (int i = 0; i < dequeues.length; ++i) {
            dequeues[i] = new DequeueRecordImpl(deserializer.readLong(), deserializer.readUUID());
        }
        return new DTXRecord(xid, enqueues, dequeues);
    }

    static class DequeueRecordImpl
    implements Transaction.DequeueRecord,
    MessageEnqueueRecord {
        private UUID _queueId;
        private long _messageNumber;

        public DequeueRecordImpl(long messageNumber, UUID queueId) {
            this._messageNumber = messageNumber;
            this._queueId = queueId;
        }

        @Override
        public MessageEnqueueRecord getEnqueueRecord() {
            return this;
        }

        @Override
        public UUID getQueueId() {
            return this._queueId;
        }

        @Override
        public long getMessageNumber() {
            return this._messageNumber;
        }
    }

    static class EnqueueRecordImpl
    implements Transaction.EnqueueRecord,
    TransactionLogResource,
    EnqueueableMessage {
        private final long _messageNumber;
        private final UUID _queueId;

        public EnqueueRecordImpl(long messageNumber, UUID queueId) {
            this._messageNumber = messageNumber;
            this._queueId = queueId;
        }

        @Override
        public TransactionLogResource getResource() {
            return this;
        }

        @Override
        public EnqueueableMessage getMessage() {
            return this;
        }

        @Override
        public String getName() {
            return this._queueId.toString();
        }

        @Override
        public UUID getId() {
            return this._queueId;
        }

        @Override
        public MessageDurability getMessageDurability() {
            return MessageDurability.DEFAULT;
        }

        @Override
        public long getMessageNumber() {
            return this._messageNumber;
        }

        @Override
        public boolean isPersistent() {
            return true;
        }

        public StoredMessage getStoredMessage() {
            throw new UnsupportedOperationException();
        }
    }
}

